/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos;

import com.alibaba.cloud.nacos.NacosConfigProperties;
import com.alibaba.cloud.nacos.diagnostics.analyzer.NacosConnectionFailureException;
import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.exception.NacosException;
import java.util.Objects;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosConfigManager {
    private static final Logger log = LoggerFactory.getLogger(NacosConfigManager.class);
    private static ConfigService service = null;
    private NacosConfigProperties nacosConfigProperties;

    public NacosConfigManager(NacosConfigProperties nacosConfigProperties) {
        this.nacosConfigProperties = nacosConfigProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static ConfigService createConfigService(NacosConfigProperties nacosConfigProperties) {
        if (!Objects.isNull(service)) return service;
        Class<NacosConfigManager> clazz = NacosConfigManager.class;
        synchronized (NacosConfigManager.class) {
            try {
                if (!Objects.isNull(service)) return service;
                service = NacosFactory.createConfigService((Properties)nacosConfigProperties.assembleConfigServiceProperties());
            }
            catch (NacosException e) {
                log.error(e.getMessage());
                throw new NacosConnectionFailureException(nacosConfigProperties.getServerAddr(), e.getMessage(), e);
            }
            return service;
        }
    }

    public ConfigService getConfigService() {
        if (Objects.isNull(service)) {
            NacosConfigManager.createConfigService(this.nacosConfigProperties);
        }
        return service;
    }

    public NacosConfigProperties getNacosConfigProperties() {
        return this.nacosConfigProperties;
    }
}

