/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.bus.rocketmq.env;

import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

public class RocketMQBusEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    private static final String PROPERTY_SOURCE_NAME = "defaultProperties";

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        this.addDefaultPropertySource(environment);
    }

    private void addDefaultPropertySource(ConfigurableEnvironment environment) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.configureDefaultProperties(map);
        this.addOrReplace(environment.getPropertySources(), map);
    }

    private void configureDefaultProperties(Map<String, Object> source) {
        String groupBindingPropertyName = this.createBindingPropertyName("springCloudBusInput", "group");
        String broadcastingPropertyName = this.createRocketMQPropertyName("springCloudBusInput", "broadcasting");
        source.put(groupBindingPropertyName, "rocketmq-bus-group");
        source.put(broadcastingPropertyName, "true");
    }

    private String createRocketMQPropertyName(String channel, String propertyName) {
        return "spring.cloud.stream.rocketmq.bindings.springCloudBusInput.consumer." + propertyName;
    }

    private String createBindingPropertyName(String channel, String propertyName) {
        return "spring.cloud.stream.bindings." + channel + "." + propertyName;
    }

    private void addOrReplace(MutablePropertySources propertySources, Map<String, Object> map) {
        PropertySource source;
        MapPropertySource target = null;
        if (propertySources.contains(PROPERTY_SOURCE_NAME) && (source = propertySources.get(PROPERTY_SOURCE_NAME)) instanceof MapPropertySource) {
            target = (MapPropertySource)source;
            for (String key : map.keySet()) {
                if (target.containsProperty(key)) continue;
                ((Map)target.getSource()).put(key, map.get(key));
            }
        }
        if (target == null) {
            target = new MapPropertySource(PROPERTY_SOURCE_NAME, map);
        }
        if (!propertySources.contains(PROPERTY_SOURCE_NAME)) {
            propertySources.addLast((PropertySource)target);
        }
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

