/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.dubbo.registry;

import com.alibaba.cloud.dubbo.metadata.repository.DubboServiceMetadataRepository;
import com.alibaba.cloud.dubbo.registry.event.ServiceInstancesChangedEvent;
import com.alibaba.cloud.dubbo.service.DubboGenericServiceFactory;
import com.alibaba.cloud.dubbo.service.DubboMetadataService;
import com.alibaba.cloud.dubbo.service.DubboMetadataServiceProxy;
import com.alibaba.cloud.dubbo.util.JSONUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.URLBuilder;
import org.apache.dubbo.registry.NotifyListener;
import org.apache.dubbo.registry.support.FailbackRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Deprecated
public abstract class AbstractSpringCloudRegistry
extends FailbackRegistry {
    public static final String SERVICES_LOOKUP_INTERVAL_PARAM_NAME = "dubbo.services.lookup.interval";
    protected static final String DUBBO_METADATA_SERVICE_CLASS_NAME = DubboMetadataService.class.getName();
    private static final Set<String> REGISTER_LISTENERS = new HashSet<String>();
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final long servicesLookupInterval;
    private final DiscoveryClient discoveryClient;
    private final DubboServiceMetadataRepository repository;
    private final DubboMetadataServiceProxy dubboMetadataConfigServiceProxy;
    private final JSONUtils jsonUtils;
    private final DubboGenericServiceFactory dubboGenericServiceFactory;
    private final ConfigurableApplicationContext applicationContext;

    public AbstractSpringCloudRegistry(URL url, DiscoveryClient discoveryClient, DubboServiceMetadataRepository dubboServiceMetadataRepository, DubboMetadataServiceProxy dubboMetadataConfigServiceProxy, JSONUtils jsonUtils, DubboGenericServiceFactory dubboGenericServiceFactory, ConfigurableApplicationContext applicationContext) {
        super(url);
        this.servicesLookupInterval = url.getParameter(SERVICES_LOOKUP_INTERVAL_PARAM_NAME, 60L);
        this.discoveryClient = discoveryClient;
        this.repository = dubboServiceMetadataRepository;
        this.dubboMetadataConfigServiceProxy = dubboMetadataConfigServiceProxy;
        this.jsonUtils = jsonUtils;
        this.dubboGenericServiceFactory = dubboGenericServiceFactory;
        this.applicationContext = applicationContext;
    }

    protected boolean shouldRegister(URL url) {
        String side = url.getParameter("side");
        boolean should = "provider".equals(side);
        if (!should && this.logger.isDebugEnabled()) {
            this.logger.debug("The URL[{}] should not be registered.", (Object)url.toString());
        }
        return should;
    }

    public final void doRegister(URL url) {
        if (!this.shouldRegister(url)) {
            return;
        }
        this.doRegister0(url);
    }

    protected abstract void doRegister0(URL var1);

    public final void doUnregister(URL url) {
        if (!this.shouldRegister(url)) {
            return;
        }
        this.doUnregister0(url);
    }

    protected abstract void doUnregister0(URL var1);

    public final void doSubscribe(URL url, NotifyListener listener) {
        if (!this.isAdminURL(url)) {
            if (this.isDubboMetadataServiceURL(url)) {
                this.subscribeDubboMetadataServiceURLs(url, listener);
                if (URLBuilder.from((URL)url).getParameter("category") != null && URLBuilder.from((URL)url).getParameter("category").contains("provider")) {
                    this.registerServiceInstancesChangedEventListener(url, listener);
                }
            } else {
                this.subscribeDubboServiceURLs(url, listener);
            }
        }
    }

    protected void subscribeDubboServiceURLs(URL url, NotifyListener listener) {
        this.doSubscribeDubboServiceURLs(url, listener);
        this.registerServiceInstancesChangedEventListener(url, listener);
    }

    private void registerServiceInstancesChangedEventListener(final URL url, final NotifyListener listener) {
        String listenerId = this.generateId(url);
        if (REGISTER_LISTENERS.add(listenerId)) {
            this.applicationContext.addApplicationListener((ApplicationListener)new ApplicationListener<ServiceInstancesChangedEvent>(){

                public void onApplicationEvent(ServiceInstancesChangedEvent event) {
                    String serviceName = event.getServiceName();
                    List<ServiceInstance> serviceInstances = event.getServiceInstances();
                    AbstractSpringCloudRegistry.this.subscribeDubboServiceURL(url, listener, serviceName, s -> serviceInstances);
                }
            });
        }
    }

    private void doSubscribeDubboServiceURLs(URL url, NotifyListener listener) {
        Set<String> subscribedServices = this.repository.getSubscribedServices();
        subscribedServices.forEach(service -> this.subscribeDubboServiceURL(url, listener, (String)service, this::getServiceInstances));
    }

    protected void subscribeDubboServiceURL(URL url, NotifyListener listener, String serviceName, Function<String, Collection<ServiceInstance>> serviceInstancesFunction) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("The Dubbo Service URL[ID : {}] is being subscribed for service[name : {}]", (Object)this.generateId(url), (Object)serviceName);
        }
        LinkedList<Object> allSubscribedURLs = new LinkedList<Object>();
        Collection<ServiceInstance> serviceInstances = serviceInstancesFunction.apply(serviceName);
        if (CollectionUtils.isEmpty(serviceInstances)) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("There is no instance from service[name : {}], and then Dubbo Service[key : {}] will not be available , please make sure the further impact", (Object)serviceName, (Object)url.getServiceKey());
            }
            if (this.isDubboMetadataServiceURL(url)) {
                this.dubboMetadataConfigServiceProxy.removeProxy(serviceName);
                this.repository.removeMetadataAndInitializedService(serviceName, url);
                this.dubboGenericServiceFactory.destroy(serviceName);
                String listenerId = this.generateId(url);
                REGISTER_LISTENERS.remove(listenerId);
            }
            allSubscribedURLs.addAll(this.emptyURLs(url));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("The subscribed URL[{}] will notify all URLs : {}", (Object)url, allSubscribedURLs);
            }
            listener.notify(allSubscribedURLs);
            return;
        }
        if (this.isDubboMetadataServiceURL(url)) {
            return;
        }
        this.repository.initializeMetadata(serviceName);
        DubboMetadataService dubboMetadataService = this.dubboMetadataConfigServiceProxy.getProxy(serviceName);
        if (dubboMetadataService == null) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("The metadata of Dubbo service[key : {}] still can't be found, it could effect the further Dubbo service invocation", (Object)url.getServiceKey());
            }
            return;
        }
        List<URL> exportedURLs = this.getExportedURLs(dubboMetadataService, url);
        for (URL exportedURL : exportedURLs) {
            String protocol = exportedURL.getProtocol();
            LinkedList subscribedURLs = new LinkedList();
            serviceInstances.forEach(serviceInstance -> {
                Integer port = this.repository.getDubboProtocolPort((ServiceInstance)serviceInstance, protocol);
                String host = serviceInstance.getHost();
                if (port == null) {
                    if (this.logger.isWarnEnabled()) {
                        this.logger.warn("The protocol[{}] port of Dubbo  service instance[host : {}] can't be resolved", (Object)protocol, (Object)host);
                    }
                } else {
                    URL subscribedURL = new URL(protocol, host, port.intValue(), exportedURL.getParameters());
                    subscribedURLs.add(subscribedURL);
                }
            });
            allSubscribedURLs.addAll(subscribedURLs);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("The subscribed URL[{}] will notify all URLs : {}", (Object)url, allSubscribedURLs);
        }
        listener.notify(allSubscribedURLs);
    }

    private String generateId(URL url) {
        return url.toString(new String[]{"version", "group", "protocol"});
    }

    private List<URL> emptyURLs(URL url) {
        return Arrays.asList(URLBuilder.from((URL)url).setProtocol("empty").removeParameter("category").build());
    }

    private List<ServiceInstance> getServiceInstances(String serviceName) {
        return StringUtils.hasText((String)serviceName) ? this.doGetServiceInstances(serviceName) : Collections.emptyList();
    }

    private List<ServiceInstance> doGetServiceInstances(String serviceName) {
        List serviceInstances;
        block2: {
            serviceInstances = Collections.emptyList();
            try {
                serviceInstances = this.discoveryClient.getInstances(serviceName);
            }
            catch (Exception e) {
                if (!this.logger.isErrorEnabled()) break block2;
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return serviceInstances;
    }

    private List<URL> getExportedURLs(DubboMetadataService dubboMetadataService, URL url) {
        String serviceInterface = url.getServiceInterface();
        String group = url.getParameter("group");
        String version = url.getParameter("version");
        String subscribedProtocol = url.getParameter("protocol");
        String exportedURLsJSON = dubboMetadataService.getExportedURLs(serviceInterface, group, version);
        return this.jsonUtils.toURLs(exportedURLsJSON).stream().filter(exportedURL -> subscribedProtocol == null || subscribedProtocol.equalsIgnoreCase(exportedURL.getProtocol())).collect(Collectors.toList());
    }

    private void subscribeDubboMetadataServiceURLs(URL url, NotifyListener listener) {
        List<URL> urls = this.repository.findSubscribedDubboMetadataServiceURLs(url);
        listener.notify(urls);
    }

    public final void doUnsubscribe(URL url, NotifyListener listener) {
    }

    public boolean isAvailable() {
        return !this.discoveryClient.getServices().isEmpty();
    }

    protected boolean isAdminURL(URL url) {
        return "admin".equals(url.getProtocol());
    }

    protected boolean isDubboMetadataServiceURL(URL url) {
        return DUBBO_METADATA_SERVICE_CLASS_NAME.equals(url.getServiceInterface());
    }
}

