/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.dubbo.registry;

import com.alibaba.cloud.dubbo.registry.AbstractServiceSubscribeHandler;
import com.alibaba.cloud.dubbo.registry.DubboCloudRegistry;
import com.alibaba.cloud.dubbo.util.DubboMetadataUtils;
import java.util.List;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.registry.NotifyListener;
import org.springframework.cloud.client.ServiceInstance;

public class MetadataServiceSubscribeHandler
extends AbstractServiceSubscribeHandler {
    private final String appName;
    private final DubboMetadataUtils dubboMetadataUtils;

    public MetadataServiceSubscribeHandler(String appName, URL url, NotifyListener listener, DubboCloudRegistry registry, DubboMetadataUtils dubboMetadataUtils) {
        super(url, listener, registry);
        this.appName = appName;
        this.dubboMetadataUtils = dubboMetadataUtils;
    }

    @Override
    public void doInit() {
        this.logger.debug("Subscription app {} MetadataService handler init", (Object)this.appName);
        List<ServiceInstance> serviceInstances = this.registry.getServiceInstances(this.appName);
        this.subscribeDubboMetadataServiceURLs(this.url, this.listener, serviceInstances);
    }

    public void refresh(List<ServiceInstance> serviceInstances) {
        this.logger.debug("Subscription app {}, instance changed, new size = {}", (Object)this.appName, (Object)serviceInstances.size());
        this.subscribeDubboMetadataServiceURLs(this.url, this.listener, serviceInstances);
    }

    private void subscribeDubboMetadataServiceURLs(URL subscribedURL, NotifyListener listener, List<ServiceInstance> serviceInstances) {
        this.logger.debug("Subscription app {}, service instance changed to size {}", (Object)this.appName, (Object)serviceInstances.size());
        String serviceInterface = subscribedURL.getServiceInterface();
        String version = subscribedURL.getParameter("version");
        String protocol = subscribedURL.getParameter("protocol");
        List<URL> urls = this.dubboMetadataUtils.getDubboMetadataServiceURLs(serviceInstances, serviceInterface, version, protocol);
        this.notifyAllSubscribedURLs(subscribedURL, urls, listener);
    }
}

