/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.stream.binder.rocketmq.convert;

import java.util.ArrayList;
import org.springframework.messaging.converter.ByteArrayMessageConverter;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.converter.MappingJackson2MessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.converter.StringMessageConverter;
import org.springframework.util.ClassUtils;

public class RocketMQMessageConverter {
    public static final String DEFAULT_NAME = "com.alibaba.cloud.stream.binder.rocketmq.convert.RocketMQMessageConverter";
    private static final boolean JACKSON_PRESENT;
    private static final boolean FASTJSON_PRESENT;
    private CompositeMessageConverter messageConverter;

    public RocketMQMessageConverter() {
        ArrayList<Object> messageConverters = new ArrayList<Object>();
        ByteArrayMessageConverter byteArrayMessageConverter = new ByteArrayMessageConverter();
        byteArrayMessageConverter.setContentTypeResolver(null);
        messageConverters.add(byteArrayMessageConverter);
        messageConverters.add(new StringMessageConverter());
        if (JACKSON_PRESENT) {
            messageConverters.add(new MappingJackson2MessageConverter());
        }
        if (FASTJSON_PRESENT) {
            try {
                messageConverters.add((MessageConverter)ClassUtils.forName((String)"com.alibaba.fastjson.support.spring.messaging.MappingFastJsonMessageConverter", (ClassLoader)ClassUtils.getDefaultClassLoader()).newInstance());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
                // empty catch block
            }
        }
        this.messageConverter = new CompositeMessageConverter(messageConverters);
    }

    public CompositeMessageConverter getMessageConverter() {
        return this.messageConverter;
    }

    public void setMessageConverter(CompositeMessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    static {
        ClassLoader classLoader = RocketMQMessageConverter.class.getClassLoader();
        JACKSON_PRESENT = ClassUtils.isPresent((String)"com.fasterxml.jackson.databind.ObjectMapper", (ClassLoader)classLoader) && ClassUtils.isPresent((String)"com.fasterxml.jackson.core.JsonGenerator", (ClassLoader)classLoader);
        FASTJSON_PRESENT = ClassUtils.isPresent((String)"com.alibaba.fastjson.JSON", (ClassLoader)classLoader) && ClassUtils.isPresent((String)"com.alibaba.fastjson.support.config.FastJsonConfig", (ClassLoader)classLoader);
    }
}

