/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.stream.binder.rocketmq.support;

import com.alibaba.cloud.stream.binder.rocketmq.support.AbstractRocketMQHeaderMapper;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.MessageHeaders;
import org.springframework.util.ClassUtils;

public class JacksonRocketMQHeaderMapper
extends AbstractRocketMQHeaderMapper {
    private static final Logger log = LoggerFactory.getLogger(JacksonRocketMQHeaderMapper.class);
    private static final List<String> DEFAULT_TRUSTED_PACKAGES = Arrays.asList("java.lang", "java.net", "java.util", "org.springframework.util");
    public static final String JSON_TYPES = "spring_json_header_types";
    private final ObjectMapper objectMapper;
    private final Set<String> trustedPackages = new LinkedHashSet<String>(DEFAULT_TRUSTED_PACKAGES);

    public JacksonRocketMQHeaderMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public JacksonRocketMQHeaderMapper(Charset charset, ObjectMapper objectMapper) {
        super(charset);
        this.objectMapper = objectMapper;
    }

    @Override
    public Map<String, String> fromHeaders(MessageHeaders headers) {
        HashMap<String, String> target = new HashMap<String, String>();
        HashMap jsonHeaders = new HashMap();
        headers.forEach((key, value) -> {
            if (this.matches((String)key)) {
                if (value instanceof String) {
                    String strValue = (String)value;
                    target.put((String)key, strValue);
                } else {
                    try {
                        String className = value.getClass().getName();
                        target.put((String)key, this.objectMapper.writeValueAsString(value));
                        jsonHeaders.put(key, className);
                    }
                    catch (Exception e) {
                        log.debug("Could not map " + key + " with type " + value.getClass().getName(), (Throwable)e);
                    }
                }
            }
        });
        if (jsonHeaders.size() > 0) {
            try {
                target.put(JSON_TYPES, this.objectMapper.writeValueAsString(jsonHeaders));
            }
            catch (JsonProcessingException | IllegalStateException e) {
                log.error("Could not add json types header", e);
            }
        }
        return target;
    }

    @Override
    public MessageHeaders toHeaders(Map<String, String> source) {
        HashMap target = new HashMap();
        Map<String, String> jsonTypes = this.decodeJsonTypes(source);
        source.forEach((key, value) -> {
            if (this.matches((String)key) && !key.equals(JSON_TYPES)) {
                if (jsonTypes.containsKey(key)) {
                    Class type = Object.class;
                    String requestedType = (String)jsonTypes.get(key);
                    boolean trusted = this.trusted(requestedType);
                    if (trusted) {
                        try {
                            type = ClassUtils.forName((String)requestedType, null);
                        }
                        catch (Exception e) {
                            log.error("Could not load class for header: " + key, (Throwable)e);
                        }
                    }
                    if (trusted) {
                        try {
                            Object val = this.decodeValue((String)value, type);
                            target.put(key, val);
                        }
                        catch (IOException e) {
                            log.error("Could not decode json type: " + value + " for key: " + key, (Throwable)e);
                            target.put(key, value);
                        }
                    } else {
                        target.put(key, new NonTrustedHeaderType((String)value, requestedType));
                    }
                } else {
                    target.put(key, value);
                }
            }
        });
        return new MessageHeaders(target);
    }

    public void addTrustedPackages(String ... packagesToTrust) {
        if (Objects.nonNull(packagesToTrust)) {
            this.addTrustedPackages(Arrays.asList(packagesToTrust));
        }
    }

    public void addTrustedPackages(Collection<String> packagesToTrust) {
        if (packagesToTrust != null) {
            for (String whiteList : packagesToTrust) {
                if ("*".equals(whiteList)) {
                    this.trustedPackages.clear();
                    break;
                }
                this.trustedPackages.add(whiteList);
            }
        }
    }

    public Set<String> getTrustedPackages() {
        return this.trustedPackages;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    private Object decodeValue(String jsonString, Class<?> type) throws IOException, LinkageError {
        NonTrustedHeaderType nth;
        Object value = this.objectMapper.readValue(jsonString, type);
        if (type.equals(NonTrustedHeaderType.class) && this.trusted((nth = (NonTrustedHeaderType)value).getUntrustedType())) {
            try {
                value = this.objectMapper.readValue(nth.getHeaderValue(), ClassUtils.forName((String)nth.getUntrustedType(), null));
            }
            catch (Exception e) {
                log.error("Could not decode header: " + nth, (Throwable)e);
            }
        }
        return value;
    }

    private Map<String, String> decodeJsonTypes(Map<String, String> source) {
        if (source.containsKey(JSON_TYPES)) {
            String value = source.get(JSON_TYPES);
            try {
                return (Map)this.objectMapper.readValue(value, (TypeReference)new TypeReference<Map<String, String>>(){});
            }
            catch (IOException e) {
                log.error("Could not decode json types: " + value, (Throwable)e);
            }
        }
        return Collections.emptyMap();
    }

    protected boolean trusted(String requestedType) {
        if (requestedType.equals(NonTrustedHeaderType.class.getName())) {
            return true;
        }
        if (!this.trustedPackages.isEmpty()) {
            int lastDot = requestedType.lastIndexOf(46);
            if (lastDot < 0) {
                return false;
            }
            String packageName = requestedType.substring(0, lastDot);
            for (String trustedPackage : this.trustedPackages) {
                if (!packageName.equals(trustedPackage) && !packageName.startsWith(trustedPackage + ".")) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static class NonTrustedHeaderType {
        private String headerValue;
        private String untrustedType;

        public NonTrustedHeaderType() {
        }

        NonTrustedHeaderType(String headerValue, String untrustedType) {
            this.headerValue = headerValue;
            this.untrustedType = untrustedType;
        }

        public void setHeaderValue(String headerValue) {
            this.headerValue = headerValue;
        }

        public String getHeaderValue() {
            return this.headerValue;
        }

        public void setUntrustedType(String untrustedType) {
            this.untrustedType = untrustedType;
        }

        public String getUntrustedType() {
            return this.untrustedType;
        }

        public String toString() {
            return "NonTrustedHeaderType [headerValue=" + this.headerValue + ", untrustedType=" + this.untrustedType + "]";
        }
    }
}

