/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csb.sdk;

import com.alibaba.csb.sdk.ContentBody;
import java.util.HashMap;
import java.util.Map;

public class HttpParameters {
    private Builder builder;

    String getApi() {
        return this.builder.api;
    }

    String getVersion() {
        return this.builder.version;
    }

    String getAccessKey() {
        return this.builder.ak;
    }

    String getSecretkey() {
        return this.builder.sk;
    }

    String getMethod() {
        return this.builder.method;
    }

    String getRequestUrl() {
        return this.builder.requestUrl;
    }

    ContentBody getContentBody() {
        return this.builder.contentBody;
    }

    String getRestfulProtocolVersion() {
        return this.builder.restfulProtocolVersion;
    }

    Map<String, String> getParamsMap() {
        return this.builder.paramsMap;
    }

    Map<String, String> getHeaderParamsMap() {
        return this.builder.headerParamsMap;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("requestUrl=").append(this.getRequestUrl());
        sb.append("\n api=").append(this.getApi());
        sb.append("\n version=").append(this.getVersion());
        sb.append("\n method=").append(this.getMethod());
        sb.append("\n accessKey=").append(this.getAccessKey());
        sb.append("\n secretKey=").append("*********");
        sb.append("\n contentBody=").append(this.getContentBody());
        sb.append("\n params: \n");
        for (Map.Entry entry : this.builder.paramsMap.entrySet()) {
            sb.append((String)entry.getKey()).append("=").append((String)entry.getValue()).append("\n");
        }
        sb.append("\n http header params: \n");
        for (Map.Entry entry : this.builder.headerParamsMap.entrySet()) {
            sb.append((String)entry.getKey()).append("=").append((String)entry.getValue()).append("\n");
        }
        return sb.toString();
    }

    private HttpParameters(Builder builder) {
        this.builder = builder;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public void validate() {
        if (this.getRequestUrl() == null) {
            throw new IllegalArgumentException("Bad httpparameters: null requestUrl!");
        }
        if (this.getApi() == null) {
            throw new IllegalArgumentException("Bad httpparameters: null api!");
        }
        if (this.getContentBody() != null) {
            if (!"post".equalsIgnoreCase(this.getMethod())) {
                throw new IllegalArgumentException("Bad httpparameters: method must be \"post\" when contentBody is set!");
            }
            if (this.getParamsMap() == null || this.getParamsMap().size() > 0) {
                // empty if block
            }
        }
    }

    public static class Builder {
        private String api;
        private String version;
        private String ak;
        private String sk;
        private String restfulProtocolVersion;
        private String method = "GET";
        private ContentBody contentBody = null;
        private String requestUrl;
        private Map<String, String> paramsMap = new HashMap<String, String>();
        private Map<String, String> headerParamsMap = new HashMap<String, String>();

        public Builder api(String api) {
            this.api = api;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder accessKey(String ak) {
            this.ak = ak;
            return this;
        }

        public Builder secretKey(String sk) {
            this.sk = sk;
            return this;
        }

        public Builder restfulProtocolVersion(String restfulProtocolVersion) {
            this.restfulProtocolVersion = restfulProtocolVersion;
            return this;
        }

        public Builder method(String method) {
            if (!("get".equalsIgnoreCase(method) || "post".equalsIgnoreCase(method) || "cget".equalsIgnoreCase(method) || "cpost".equalsIgnoreCase(method))) {
                throw new IllegalArgumentException("only support 'GET', 'CGET' or 'POST', 'CPOST' method");
            }
            this.method = method;
            return this;
        }

        public Builder requestURL(String url) {
            this.requestUrl = url;
            return this;
        }

        public Builder clearParamsMap() {
            this.paramsMap.clear();
            return this;
        }

        public Builder putParamsMap(String key, String value) {
            this.paramsMap.put(key, value);
            return this;
        }

        public Builder putParamsMapAll(HashMap<String, String> map) {
            this.paramsMap.putAll(map);
            return this;
        }

        public Builder clearHeaderParamsMap() {
            this.headerParamsMap.clear();
            return this;
        }

        public Builder putHeaderParamsMap(String key, String value) {
            this.headerParamsMap.put(key, value);
            return this;
        }

        public Builder putHeaderParamsMapAll(HashMap<String, String> map) {
            this.headerParamsMap.putAll(map);
            return this;
        }

        public Builder contentBody(ContentBody cb) {
            this.contentBody = cb;
            return this;
        }

        public HttpParameters build() {
            return new HttpParameters(this);
        }
    }
}

