/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csb.sdk.internel;

import com.alibaba.csb.sdk.HttpCallerException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HeaderElement;
import org.apache.http.HttpResponse;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;

public class HttpClientFactory {
    private static ConnectionKeepAliveStrategy createKeepAliveStrategy() {
        return new ConnectionKeepAliveStrategy(){

            public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
                while (it.hasNext()) {
                    HeaderElement he = it.nextElement();
                    String param = he.getName();
                    String value = he.getValue();
                    if (value == null || !param.equalsIgnoreCase("timeout")) continue;
                    return Long.parseLong(value) * 1000L;
                }
                return 5000L;
            }
        };
    }

    public static CloseableHttpClient createCloseableHttpClient(PoolingHttpClientConnectionManager connManager) throws HttpCallerException {
        CloseableHttpClient client;
        ConnectionKeepAliveStrategy myStrategy = HttpClientFactory.createKeepAliveStrategy();
        try {
            client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).setKeepAliveStrategy(myStrategy).build();
        }
        catch (Exception e) {
            throw new HttpCallerException("Failed to create httpclient: " + e.getMessage(), e);
        }
        return client;
    }

    public static PoolingHttpClientConnectionManager createConnManager() throws HttpCallerException {
        try {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }).build();
            NoopHostnameVerifier hostnameVerifier = NoopHostnameVerifier.INSTANCE;
            SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)hostnameVerifier);
            Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslSocketFactory).build();
            return new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        }
        catch (Exception e) {
            throw new HttpCallerException("Failed to create httpclient: " + e.getMessage(), e);
        }
    }
}

