/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csb.utils;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicReference;

public class IPUtils {
    private static String DEFAULT_IP = "127000000001";
    private static final AtomicReference<String> IP = new AtomicReference();

    public static String getLocalHostIP() {
        Enumeration<NetworkInterface> allNetInterfaces;
        String ip = IP.get();
        if (ip != null) {
            return ip;
        }
        try {
            allNetInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            try {
                InetAddress jdkSuppliedAddress = InetAddress.getLocalHost();
                IP.compareAndSet(null, jdkSuppliedAddress.getHostAddress());
            }
            catch (UnknownHostException ex) {
                IP.compareAndSet(null, DEFAULT_IP);
            }
            return IP.get();
        }
        while (allNetInterfaces.hasMoreElements()) {
            NetworkInterface ni;
            String displayName;
            while ((displayName = (ni = allNetInterfaces.nextElement()).getDisplayName()) != null && displayName.startsWith("virbr")) {
            }
            Enumeration<InetAddress> addresses = ni.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress address = addresses.nextElement();
                if (address.isLoopbackAddress() || address.getHostAddress().indexOf(":") != -1) continue;
                IP.compareAndSet(null, address.getHostAddress());
                return IP.get();
            }
        }
        IP.compareAndSet(null, DEFAULT_IP);
        return IP.get();
    }
}

