/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csb.sdk;

import com.alibaba.csb.sdk.CmdCaller;
import com.alibaba.csb.sdk.ContentBody;
import com.alibaba.csb.sdk.HttpCaller;
import com.alibaba.csb.sdk.HttpParameters;
import com.alibaba.csb.sdk.HttpReturn;
import com.alibaba.csb.sdk.Version;
import com.alibaba.csb.sdk.i18n.MessageHelper;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;

public class CmdHttpCaller {
    private static final String SDK_VERSION = "1.1.5.0";
    public static Options opt = new Options();

    private static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static void main(String[] args) {
        DefaultParser parser = new DefaultParser();
        Boolean isDebug = false;
        try {
            String[] kv;
            CommandLine commandline = parser.parse(opt, args);
            if (commandline.getOptions().length == 0 && commandline.getArgs().length > 0) {
                CmdCaller.main(args);
                return;
            }
            if (commandline.hasOption("h")) {
                CmdHttpCaller.usage(null);
                return;
            }
            String ak = commandline.getOptionValue("ak");
            String sk = commandline.getOptionValue("sk");
            String api = commandline.getOptionValue("api");
            String version = commandline.getOptionValue("version");
            Boolean sdkv = commandline.hasOption("sdkv");
            String method = commandline.getOptionValue("method");
            String[] headers = commandline.getOptionValues("H");
            String[] params = commandline.getOptionValues("D");
            String url = commandline.getOptionValue("url");
            String proxy = commandline.getOptionValue("proxy");
            String cbJSON = commandline.getOptionValue("cbJSON");
            boolean nonce = commandline.hasOption("nonce");
            isDebug = commandline.hasOption("d");
            Boolean changeCharset = commandline.hasOption("cc");
            if (sdkv.booleanValue()) {
                Version.version();
                return;
            }
            String signImpl = commandline.getOptionValue("sign");
            String verifySignImpl = commandline.getOptionValue("verify");
            if (isDebug.booleanValue()) {
                System.out.println("url=" + url);
                System.out.println("api=" + api);
                System.out.println("version=" + version);
                System.out.println("ak=" + ak);
                System.out.println("sk=" + sk);
                System.out.println("proxy=" + proxy);
                System.out.println("nonce=" + nonce);
                System.out.println("signImpl=" + signImpl);
                System.out.println("verifySignImpl=" + verifySignImpl);
                CmdHttpCaller.printKV("HTTP Headers", headers);
                CmdHttpCaller.printKV("HTTP Params", params);
            }
            if (CmdHttpCaller.isEmpty(api)) {
                CmdHttpCaller.usage(MessageHelper.getMessage("cli.defparam", "-api"));
                return;
            }
            if (CmdHttpCaller.isEmpty(version)) {
                CmdHttpCaller.usage(MessageHelper.getMessage("cli.defparam", "-version"));
                return;
            }
            if (CmdHttpCaller.isEmpty(url)) {
                CmdHttpCaller.usage(MessageHelper.getMessage("cli.defparam", "-url"));
                return;
            }
            if (method == null) {
                method = "get";
            }
            HttpParameters.Builder builder = HttpParameters.newBuilder();
            builder.api(api).version(version).method(method).requestURL(url).accessKey(ak).secretKey(sk).signImpl(signImpl).verifySignImpl(verifySignImpl);
            if (headers != null) {
                for (String header : headers) {
                    kv = header.split(":", 2);
                    if (kv == null || kv.length != 2) {
                        System.out.println("" + header);
                        return;
                    }
                    builder.putHeaderParamsMap(kv[0], kv[1]);
                }
            }
            if (params != null) {
                for (String param : params) {
                    kv = param.split("=", 2);
                    if (kv == null || kv.length != 2) {
                        System.out.println(MessageHelper.getMessage("cli.defh", param));
                        return;
                    }
                    builder.putParamsMap(kv[0], kv[1]);
                }
            }
            if (cbJSON != null) {
                if ("cget".equalsIgnoreCase(method) || "get".equalsIgnoreCase(method)) {
                    System.out.println(MessageHelper.getMessage("cli.defpost", new String[0]));
                    return;
                }
                if (cbJSON.startsWith("'")) {
                    System.out.println(MessageHelper.getMessage("cli.json.prefix", new String[0]));
                    return;
                }
                builder.contentBody(new ContentBody(cbJSON));
            }
            builder.nonce(nonce);
            if (isDebug.booleanValue()) {
                builder.diagnostic(true);
            }
            boolean curlOnly = false;
            if (method.toLowerCase().startsWith("c")) {
                curlOnly = true;
                HttpCaller.setCurlResponse(true);
            }
            StringBuffer resHttpHeaders = new StringBuffer();
            if (proxy != null) {
                String errMsg = MessageHelper.getMessage("cli.errproxy", proxy);
                String[] pcs = proxy.split(":");
                if (pcs == null || pcs.length != 2) {
                    System.out.println(errMsg);
                    return;
                }
                try {
                    HttpCaller.setProxyHost(pcs[0], Integer.parseInt(pcs[1]), null);
                }
                catch (Exception e) {
                    System.out.println(errMsg);
                    return;
                }
            }
            HttpReturn ret = HttpCaller.invokeReturn(builder.build());
            if (curlOnly) {
                System.out.println("---- curlString = " + ret.response);
            } else {
                if (isDebug.booleanValue()) {
                    System.out.println("Diagnostic Info:" + ret.diagnosticInfo);
                }
                System.out.println("---- response http headers = " + ret.responseHeaders);
                if (changeCharset.booleanValue()) {
                    System.out.println("\n---- retStr after changeCharset = " + HttpCaller.changeCharset(ret.response));
                } else {
                    System.out.println("---- retStr = " + ret.response);
                }
                int times = Integer.getInteger("test.stress.times", 0);
                for (int i = 2; i <= times; ++i) {
                    ret = HttpCaller.invokeReturn(builder.build());
                    System.out.println("---- retStr [#" + i + "] = " + ret.response);
                }
            }
        }
        catch (Exception e) {
            System.out.println("-- operation error\uff1a" + e.getMessage());
            e.printStackTrace(System.out);
        }
    }

    private static void printKV(String title, String[] kvs) {
        if (kvs != null) {
            System.out.println("---- " + title + " ----");
            for (String kv : kvs) {
                System.out.print(kv);
            }
            System.out.println("---- ---- ----");
        }
    }

    static void usage(String message) {
        if (message != null) {
            System.out.println("Bad param: " + message);
        }
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("java -jar http-client.jar [options...]", opt);
        System.out.println("\ncurrent SDK version:1.1.5.0\n----");
        System.out.println("\nCurrent JDK Env: file.encoding=" + System.getProperty("file.encoding") + "");
        Version.version();
    }

    static {
        opt.addOption("url", true, "\u6d4b\u8bd5:" + MessageHelper.getMessage("cli.url", new String[0]));
        opt.addOption("api", true, MessageHelper.getMessage("cli.api", new String[0]));
        opt.addOption("version", true, MessageHelper.getMessage("cli.version", new String[0]));
        opt.addOption("ak", true, MessageHelper.getMessage("cli.ak", new String[0]));
        opt.addOption("sk", true, MessageHelper.getMessage("cli.sk", new String[0]));
        opt.addOption("method", true, MessageHelper.getMessage("cli.method", new String[0]));
        opt.addOption("proxy", true, MessageHelper.getMessage("cli.proxy", new String[0]));
        opt.addOption("H", true, MessageHelper.getMessage("cli.h", new String[0]));
        opt.addOption("D", true, MessageHelper.getMessage("cli.d", new String[0]));
        opt.addOption("cbJSON", true, MessageHelper.getMessage("cli.cbJSON", "\"{'name':'wiseking'}\""));
        opt.addOption("nonce", false, MessageHelper.getMessage("cli.nonce", new String[0]));
        opt.addOption("h", "help", false, MessageHelper.getMessage("cli.help", new String[0]));
        opt.addOption("d", "debug", false, MessageHelper.getMessage("cli.debug", new String[0]));
        opt.addOption("cc", "changeCharset", false, MessageHelper.getMessage("cli.change.charset", new String[0]));
        opt.addOption("sdkv", "sdk-version", false, MessageHelper.getMessage("cli.sdk.version", new String[0]));
        opt.addOption("sign", "signImpl", true, MessageHelper.getMessage("cli.signImpl", new String[0]));
        opt.addOption("verify", "verifySignImpl", true, MessageHelper.getMessage("cli.verifySignImpl", new String[0]));
    }
}

