/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csb.sdk.internel;

import com.alibaba.csb.sdk.ContentBody;
import com.alibaba.csb.sdk.HttpCallerException;
import com.alibaba.csb.sdk.SdkLogger;
import com.alibaba.csb.sdk.security.SignUtil;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HTTP;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpClientHelper {
    public static void printDebugInfo(String msg) {
        if (SdkLogger.isLoggable()) {
            SdkLogger.print(msg);
        }
    }

    public static void mergeParams(Map<String, List<String>> urlParamsMap, Map<String, String> paramsMap, boolean decodeFlag) throws HttpCallerException {
        if (paramsMap != null) {
            for (Map.Entry<String, String> kv : paramsMap.entrySet()) {
                String value = HttpClientHelper.decodeValue(kv.getKey(), kv.getValue(), decodeFlag);
                urlParamsMap.put(kv.getKey(), Arrays.asList(value));
            }
        }
    }

    public static Map<String, String> newParamsMap(Map<String, List<String>> paramsMap, String apiName, String version, String accessKey, String securityKey, boolean timestampFlag, boolean nonceFlag, Map<String, String> extSignHeaders, StringBuffer signDiagnosticInfo, String signImpl, String verifySignImpl) {
        return SignUtil.newParamsMap(paramsMap, apiName, version, accessKey, securityKey, timestampFlag, nonceFlag, extSignHeaders, signDiagnosticInfo, signImpl, verifySignImpl);
    }

    public static String trimWhiteSpaces(String value) {
        if (value == null) {
            return value;
        }
        return value.trim();
    }

    public static String trimUrl(String requestURL) {
        int pos = requestURL.indexOf("?");
        String ret = requestURL;
        if (pos >= 0) {
            ret = requestURL.substring(0, pos);
        }
        return ret;
    }

    public static void validateParams(String apiName, String accessKey, String securityKey, Map<String, String> paramsMap) throws HttpCallerException {
        if (apiName == null) {
            throw new HttpCallerException(new InvalidParameterException("param apiName can not be null!"));
        }
        if (accessKey != null && securityKey == null) {
            throw new HttpCallerException(new InvalidParameterException("param securityKey can not be null for a given accessKey!"));
        }
        if (paramsMap != null) {
            for (Map.Entry<String, String> kv : paramsMap.entrySet()) {
                if (kv.getValue() != null) continue;
                throw new HttpCallerException(new InvalidParameterException(String.format("bad parasMap, the value for key [ %s ] is null, please remove the key or set its value, e.g. \"\"!", kv.getKey())));
            }
        }
    }

    private static String decodeValue(String key, String value, boolean decodeFlag) throws HttpCallerException {
        if (decodeFlag) {
            if (value == null) {
                throw new HttpCallerException("bad params, the value for key {" + key + "} is null!");
            }
            return URLDecoder.decode(value);
        }
        return value;
    }

    public static Map<String, List<String>> parseUrlParamsMap(String requestURL, boolean decodeFlag) throws HttpCallerException {
        boolean questionMarkFlag = requestURL.contains("?");
        HashMap<String, List<String>> urlParamsMap = new HashMap<String, List<String>>();
        if (questionMarkFlag) {
            String[] params;
            int pos = requestURL.indexOf("?");
            String paramStr = requestURL.substring(pos + 1);
            for (String param : params = paramStr.split("&")) {
                pos = param.indexOf("=");
                if (pos <= 0) {
                    throw new HttpCallerException("bad request URL, url params error:" + requestURL);
                }
                String key = HttpClientHelper.decodeValue("", param.substring(0, pos), decodeFlag);
                String value = param.substring(pos + 1);
                ArrayList<String> values = (ArrayList<String>)urlParamsMap.get(key);
                if (values == null) {
                    values = new ArrayList<String>();
                }
                values.add(HttpClientHelper.decodeValue(key, value, decodeFlag));
                urlParamsMap.put(key, values);
            }
        }
        return urlParamsMap;
    }

    private static void setHeaders(HttpPost httpPost, Map<String, String> newParamsMap) {
        if (newParamsMap != null) {
            for (Map.Entry<String, String> kv : newParamsMap.entrySet()) {
                httpPost.addHeader(kv.getKey(), kv.getValue());
            }
        }
    }

    public static void setHeaders(HttpGet httpGet, Map<String, String> newParamsMap) {
        if (newParamsMap != null) {
            for (Map.Entry<String, String> kv : newParamsMap.entrySet()) {
                httpGet.addHeader(kv.getKey(), kv.getValue());
            }
        }
    }

    public static String genCurlHeaders(Map<String, String> newParamsMap) {
        if (newParamsMap != null) {
            StringBuffer sb = new StringBuffer();
            for (Map.Entry<String, String> kv : newParamsMap.entrySet()) {
                sb.append("-H \"").append(kv.getKey()).append(":").append(kv.getValue()).append("\"  ");
            }
            return sb.toString();
        }
        return "";
    }

    public static String createPostCurlString(String url, Map<String, String> params, Map<String, String> headerParams, ContentBody cb, Map<String, String> directHheaderParamsMap) {
        StringBuffer sb = new StringBuffer("curl ");
        sb.append(HttpClientHelper.genCurlHeaders(directHheaderParamsMap));
        sb.append(HttpClientHelper.genCurlHeaders(headerParams));
        if (params != null) {
            StringBuffer postSB = new StringBuffer();
            for (Map.Entry<String, String> e : params.entrySet()) {
                if (postSB.length() > 0) {
                    postSB.append("&");
                }
                postSB.append(e.getKey()).append("=").append(URLEncoder.encode(e.getValue()));
            }
            if (postSB.length() > 0) {
                sb.append(" -d \"");
                postSB.append("\"");
                sb.append(postSB.toString());
            } else {
                sb.append("--data ''");
            }
        } else {
            sb.append("--data '");
            sb.append(HttpClientHelper.urlEncodedString(HttpClientHelper.toNVP(params), "UTF-8"));
            sb.append("'");
        }
        sb.append(" --insecure ");
        sb.append("\"");
        sb.append(url);
        sb.append("\"");
        return sb.toString();
    }

    private static String urlEncodedString(List<NameValuePair> parameters, String charset) {
        return URLEncodedUtils.format(parameters, charset != null ? charset : HTTP.DEF_CONTENT_CHARSET.name());
    }

    public static HttpPost createPost(String url, Map<String, String> urlParams, Map<String, String> headerParams, ContentBody cb) {
        String newUrl = url;
        if (cb != null && urlParams != null && urlParams != null) {
            List<NameValuePair> nvps = HttpClientHelper.toNVP(urlParams);
            String newParamStr = HttpClientHelper.urlEncodedString(nvps, "UTF-8");
            newUrl = !url.contains("?") ? String.format("%s?%s", url, newParamStr) : String.format("%s&%s", url, newParamStr);
        }
        HttpClientHelper.printDebugInfo("new requestURL=" + newUrl);
        HttpPost httpost = new HttpPost(newUrl);
        HttpClientHelper.setHeaders(httpost, headerParams);
        if (cb == null) {
            List<NameValuePair> nvps = HttpClientHelper.toNVP(urlParams);
            try {
                httpost.setEntity(new UrlEncodedFormEntity(nvps, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        } else if (cb.getContentType() == ContentBody.Type.JSON) {
            StringEntity entity = new StringEntity((String)cb.getContentBody(), "UTF-8");
            entity.setContentType(ContentBody.Type.JSON.getContentType());
            httpost.setEntity(entity);
        } else {
            httpost.setHeader("Content-Type", ContentBody.Type.BINARY.getContentType());
            ByteArrayEntity be = new ByteArrayEntity((byte[])cb.getContentBody());
            httpost.setEntity(be);
        }
        return httpost;
    }

    private static List<NameValuePair> toNVP(Map<String, String> urlParams) {
        ArrayList<NameValuePair> nvps = new ArrayList<NameValuePair>();
        if (urlParams != null) {
            Set<String> keySet = urlParams.keySet();
            for (String key : keySet) {
                nvps.add(new BasicNameValuePair(key, urlParams.get(key)));
            }
        }
        return nvps;
    }

    public static void setDirectHeaders(HttpPost httpPost, Map<String, String> directHheaderParamsMap) {
        if (directHheaderParamsMap == null) {
            return;
        }
        for (Map.Entry<String, String> kv : directHheaderParamsMap.entrySet()) {
            if (kv.getKey() == null || !"Content-Type".equals(kv.getKey()) && httpPost.containsHeader(kv.getKey())) continue;
            httpPost.addHeader(kv.getKey(), kv.getValue());
        }
    }

    public static String getUrlPathInfo(String url) throws HttpCallerException {
        URL urlStr = null;
        try {
            urlStr = new URL(url);
        }
        catch (Exception e) {
            throw new HttpCallerException("url is unformat, url is " + url);
        }
        String path = urlStr.getPath();
        return path;
    }

    public static String fetchResHeaders(HttpResponse response) {
        if (response != null) {
            StringBuffer body = new StringBuffer();
            body.append(String.format("\"%s\":\"%s\"", "HTTP-STATUS", response.getStatusLine()));
            for (Header header : response.getAllHeaders()) {
                if (body.length() > 0) {
                    body.append(",");
                }
                body.append(String.format("\"%s\":\"%s\"", header.getName(), header.getValue()));
            }
            return String.format("{%s}", body.toString());
        }
        return null;
    }

    public static String generateAsEncodeRequestUrl(String requestURL, Map<String, List<String>> urlParamsMap) {
        requestURL = HttpClientHelper.trimUrl(requestURL);
        StringBuffer params = new StringBuffer();
        for (Map.Entry<String, List<String>> kv : urlParamsMap.entrySet()) {
            if (params.length() > 0) {
                params.append("&");
            }
            if (kv.getValue() == null) continue;
            List<String> vlist = kv.getValue();
            for (String v : vlist) {
                params.append(URLEncoder.encode(kv.getKey())).append("=").append(URLEncoder.encode(v));
            }
        }
        String newRequestURL = requestURL;
        if (params.length() > 0) {
            newRequestURL = newRequestURL + "?" + params.toString();
        }
        HttpClientHelper.printDebugInfo("-- requestURL=" + newRequestURL);
        return newRequestURL;
    }
}

