/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.sentinel;

import com.alibaba.csp.ahas.sentinel.AhasGlobalContext;
import com.alibaba.csp.ahas.sentinel.SentinelAcmDataSourceService;
import com.alibaba.csp.ahas.sentinel.SentinelRequestHandler;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.auth.api.AuthUtil;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.api.client.ClientInfoService;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.api.transport.TransportService;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.client.DefaultClientInfoService;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.exception.SentinelDisabledException;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.heartbeat.DefaultHeartbeatService;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.heartbeat.HeartbeatService;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.init.AhasInitFunc;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.transport.DefaultTransportService;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.transport.api.Response;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.transport.api.ServiceConstants;
import com.alibaba.csp.ahas.shaded.com.taobao.middleware.logger.support.LogLog;
import com.alibaba.csp.sentinel.Constants;
import com.alibaba.csp.sentinel.cluster.client.auth.ClientAuthConfigRegistry;
import com.alibaba.csp.sentinel.cluster.client.auth.ClientCredentialSupplier;
import com.alibaba.csp.sentinel.cluster.client.auth.ssl.CertStorage;
import com.alibaba.csp.sentinel.cluster.registry.ConfigSupplierRegistry;
import com.alibaba.csp.sentinel.command.handler.FetchActiveRuleCommandHandler;
import com.alibaba.csp.sentinel.command.handler.FetchJsonTreeCommandHandler;
import com.alibaba.csp.sentinel.command.handler.FetchSimpleClusterNodeCommandHandler;
import com.alibaba.csp.sentinel.command.handler.OnOffGetCommandHandler;
import com.alibaba.csp.sentinel.command.handler.OnOffSetCommandHandler;
import com.alibaba.csp.sentinel.command.handler.SendMetricCommandHandler;
import com.alibaba.csp.sentinel.command.handler.VersionCommandHandler;
import com.alibaba.csp.sentinel.command.handler.cluster.FetchClusterModeCommandHandler;
import com.alibaba.csp.sentinel.command.handler.cluster.ModifyClusterModeCommandHandler;
import com.alibaba.csp.sentinel.concurrent.NamedThreadFactory;
import com.alibaba.csp.sentinel.init.InitFunc;
import com.alibaba.csp.sentinel.init.InitOrder;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.spi.SpiOrder;
import com.alibaba.csp.sentinel.transport.HeartbeatSender;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.csp.sentinel.util.function.Supplier;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;

@SpiOrder(value=-10000)
@InitOrder(value=-2147483648)
public class DefaultSentinelSdkService
implements InitFunc,
HeartbeatSender {
    public static final String SENTINEL_ENV_CLASS = "com.alibaba.csp.sentinel.Env";
    private static final ClientInfoService clientInfoService = new DefaultClientInfoService();
    private static final TransportService transportService = new DefaultTransportService();
    private static final HeartbeatService heartbeatService = new DefaultHeartbeatService();
    private static final AtomicBoolean isAhasInit = new AtomicBoolean(false);
    private static final AtomicBoolean ahasInitSuccess = new AtomicBoolean(false);
    private static final ExecutorService executor = Executors.newSingleThreadExecutor(new NamedThreadFactory("AhasSentinelSdkService-init-thread"));
    private static DefaultSentinelSdkService defaultSentinelSdkService;
    private static String ahasSdkVersion;

    public static synchronized DefaultSentinelSdkService getInstance() {
        if (defaultSentinelSdkService == null) {
            defaultSentinelSdkService = new DefaultSentinelSdkService();
        }
        return defaultSentinelSdkService;
    }

    public DefaultSentinelSdkService() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    DefaultSentinelSdkService.this.initAhasTransport();
                }
                catch (Throwable e) {
                    RecordLog.warn("[DefaultSentinelSdkService] Failed to initialize AHAS transport", e);
                    System.err.println("ERROR: AHAS init fail");
                }
            }
        };
        executor.submit(runnable);
    }

    @Override
    public void init() throws Exception {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (!ahasInitSuccess.get()) {
                    return;
                }
                try {
                    DefaultSentinelSdkService.this.initSentinelClusterFlow(ahasSdkVersion);
                    LogLog.setQuietMode(true);
                    SentinelAcmDataSourceService acmDataSourceService = new SentinelAcmDataSourceService(clientInfoService);
                    acmDataSourceService.initAcmDataSource();
                    DefaultSentinelSdkService.this.initSentinel();
                }
                catch (Throwable throwable) {
                    RecordLog.warn("[DefaultSentinelSdkService] Init AHAS Sentinel or ACM error", throwable);
                }
            }
        };
        executor.submit(runnable);
    }

    private void initSentinelClusterFlow(final String version) {
        final String userId = clientInfoService.getUserId();
        final String ahasNamespace = clientInfoService.getNamespace();
        ConfigSupplierRegistry.setNamespaceSupplier(new Supplier<String>(){

            @Override
            public String get() {
                return userId + "|" + ahasNamespace + "|" + clientInfoService.getAppName();
            }
        });
        ClientAuthConfigRegistry.setClientCredentialSupplier(new ClientCredentialSupplier(){

            @Override
            public Map<String, String> getCredentials() {
                HashMap<String, String> map = new HashMap<String, String>(8);
                map.put("uid", userId);
                map.put("ahasNs", ahasNamespace);
                map.put("sk", AuthUtil.getSecretKey());
                map.put("instanceId", clientInfoService.getAid());
                map.put("clientType", "JAVA_SDK");
                map.put("clientVersion", version);
                map.put("cpbId", String.valueOf(1));
                return map;
            }
        });
        CertStorage.createOrUpdateClientCert(clientInfoService.getRegionId(), clientInfoService.getAhasEnv());
    }

    private void initAhasTransport() throws Exception {
        if (!isAhasInit.compareAndSet(false, true)) {
            return;
        }
        this.registerCommandHandler();
        ahasSdkVersion = this.getAhasVersion("1.6.4");
        System.setProperty("ahas.version", this.getWholeVersion(ahasSdkVersion));
        int times = 0;
        while (true) {
            try {
                ((AhasInitFunc)((Object)clientInfoService)).init("JAVA_SDK", null);
                transportService.init(clientInfoService);
                heartbeatService.init(clientInfoService, transportService);
            }
            catch (Throwable throwable) {
                if (throwable instanceof SentinelDisabledException) {
                    RecordLog.info("[DefaultSentinelSdkService] sentinel disabled, stop connect to server.", new Object[0]);
                    throw new SentinelDisabledException("sentinel disabled.");
                }
                RecordLog.warn("[DefaultSentinelSdkService] init ahas fail, will retry " + times, throwable);
                ++times;
                try {
                    Thread.sleep(10000L);
                }
                catch (Exception exception) {}
                continue;
            }
            break;
        }
        RecordLog.info("[DefaultSentinelSdkService] AHAS gateway host: " + clientInfoService.getGatewayHost() + ", port:" + clientInfoService.getGatewayPort(), new Object[0]);
        AhasGlobalContext.setClientInfoService(clientInfoService);
        ahasInitSuccess.set(true);
        RecordLog.info("AHAS transport has been initialized successfully", new Object[0]);
    }

    private String getAhasVersion(String defaultVersion) {
        String gwVersion = defaultVersion;
        try {
            String version = DefaultSentinelSdkService.class.getPackage().getImplementationVersion();
            if (StringUtil.isNotBlank(version)) {
                gwVersion = version;
            }
        }
        catch (Throwable e) {
            RecordLog.warn("[DefaultSentinelSdkService] Using default AHAS version, ignore exception", e);
        }
        return gwVersion;
    }

    private String getWholeVersion(String ahasVersion) {
        String coreVersion = Constants.SENTINEL_VERSION;
        String wholeVersion = coreVersion + "_" + ahasVersion;
        RecordLog.info("[DefaultSentinelSdkService] wholeVersion: " + wholeVersion, new Object[0]);
        return wholeVersion;
    }

    private void initSentinel() throws Exception {
        try {
            this.getClass().getClassLoader().loadClass(SENTINEL_ENV_CLASS);
        }
        catch (ClassNotFoundException e) {
            RecordLog.warn("[DefaultSentinelSdkService][ERROR] com.alibaba.csp.sentinel.Env not found!", e);
        }
    }

    private void registerCommandHandler() {
        transportService.registerHandler(ServiceConstants.Sentinel.CLUSTER_NODE.getHandlerName(), new SentinelRequestHandler<String>(new FetchSimpleClusterNodeCommandHandler()));
        transportService.registerHandler(ServiceConstants.Sentinel.JSON_TREE.getHandlerName(), new SentinelRequestHandler<String>(new FetchJsonTreeCommandHandler()));
        transportService.registerHandler(ServiceConstants.Sentinel.METRIC.getHandlerName(), new SentinelRequestHandler<String>(new SendMetricCommandHandler()));
        transportService.registerHandler(ServiceConstants.Sentinel.GET_RULES.getHandlerName(), new SentinelRequestHandler<String>(new FetchActiveRuleCommandHandler()));
        transportService.registerHandler(ServiceConstants.Sentinel.VERSION.getHandlerName(), new SentinelRequestHandler<String>(new VersionCommandHandler()));
        transportService.registerHandler(ServiceConstants.Sentinel.GET_SWITCH.getHandlerName(), new SentinelRequestHandler<String>(new OnOffGetCommandHandler()));
        transportService.registerHandler(ServiceConstants.Sentinel.SET_SWITCH.getHandlerName(), new SentinelRequestHandler<String>(new OnOffSetCommandHandler()));
        transportService.registerHandler(ServiceConstants.Sentinel.SET_CLUSTER_MODE.getHandlerName(), new SentinelRequestHandler<String>(new ModifyClusterModeCommandHandler()));
        transportService.registerHandler(ServiceConstants.Sentinel.GET_CLUSTER_MODE.getHandlerName(), new SentinelRequestHandler<String>(new FetchClusterModeCommandHandler()));
    }

    @Override
    public boolean sendHeartbeat() throws Exception {
        if (!ahasInitSuccess.get() || clientInfoService.getSentinalDisable() == 1) {
            return false;
        }
        Response<String> mapResponse = heartbeatService.sendHeartbeat();
        if (!mapResponse.isSuccess()) {
            throw new RuntimeException(mapResponse.toString());
        }
        return mapResponse.isSuccess();
    }

    @Override
    public long intervalMs() {
        return 5000L;
    }
}

