/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.sentinel.adapter.servlet;

import com.alibaba.csp.ahas.sentinel.util.FileConfigUtil;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public final class UrlCleanerPropertyLocalConfig {
    public static final String URL_CONFIG_FILE_KEY = "csp.sentinel.url.clean.config.path";
    public static final String STATIC_SUFFIX_EXCLUDE_KEY = "csp.sentinel.url.suffix.exclude.pattern";
    public static final String DEFAULT_URL_CONFIG_FILE_NAME = "ahas-sentinel-url-clean.properties";
    public static final String DEFAULT_EXCLUDE_SUFFIX_PATTERN = "png,gif,js,css,htm,html,jpg,jpeg,map,ico,ttf,woff";
    private static final Map<String, String> CONFIG_MAP = new HashMap<String, String>();
    private static String[] SUFFIX_EXCLUDE_MAP = null;

    private static void loadConfigFromFile() {
        Properties properties;
        String filePath;
        String[] arr;
        String excludeSuffixPattern = System.getProperty(STATIC_SUFFIX_EXCLUDE_KEY);
        if (StringUtil.isBlank(excludeSuffixPattern)) {
            excludeSuffixPattern = DEFAULT_EXCLUDE_SUFFIX_PATTERN;
        }
        if ((arr = excludeSuffixPattern.split(",")).length > 0) {
            SUFFIX_EXCLUDE_MAP = arr;
        }
        if (StringUtil.isEmpty(filePath = System.getProperty(URL_CONFIG_FILE_KEY))) {
            filePath = DEFAULT_URL_CONFIG_FILE_NAME;
        }
        if ((properties = FileConfigUtil.loadProperties(filePath)) != null && !properties.isEmpty()) {
            RecordLog.info("[UrlCleanerPropertyLocalConfig] Loading UrlCleaner config from " + filePath, new Object[0]);
            for (Map.Entry<Object, Object> e : properties.entrySet()) {
                RecordLog.info("[UrlCleanerPropertyLocalConfig] URL with prefix <{0}> will be unified as <{1}>", e.getKey(), e.getValue());
                CONFIG_MAP.put(e.getKey().toString(), e.getValue().toString());
            }
        }
    }

    static String[] getSuffixExcludeMap() {
        return SUFFIX_EXCLUDE_MAP;
    }

    public static Map<String, String> getConfigMap() {
        return CONFIG_MAP;
    }

    private UrlCleanerPropertyLocalConfig() {
    }

    static {
        try {
            UrlCleanerPropertyLocalConfig.loadConfigFromFile();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

