/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.com.alibaba.metrics;

import com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.com.alibaba.metrics.Clock;
import com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.com.alibaba.metrics.MetricSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public abstract class CachedMetricSet
implements MetricSet {
    protected static long DEFAULT_DATA_TTL = 5000L;
    protected long dataTTL;
    protected AtomicLong lastCollectTime;
    protected Clock clock;
    private final Object collectLock = new Object();

    public CachedMetricSet() {
        this(DEFAULT_DATA_TTL, TimeUnit.MILLISECONDS, Clock.defaultClock());
    }

    public CachedMetricSet(long dataTTL, TimeUnit unit) {
        this(dataTTL, unit, Clock.defaultClock());
    }

    public CachedMetricSet(long dataTTL, TimeUnit unit, Clock clock) {
        this.dataTTL = unit.toMillis(dataTTL);
        this.clock = clock;
        this.lastCollectTime = new AtomicLong(clock.getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshIfNecessary() {
        if (this.clock.getTime() - this.lastCollectTime.get() > this.dataTTL) {
            Object object = this.collectLock;
            synchronized (object) {
                if (this.clock.getTime() - this.lastCollectTime.get() > this.dataTTL) {
                    this.getValueInternal();
                    this.lastCollectTime.set(this.clock.getTime());
                }
            }
        }
    }

    @Override
    public long lastUpdateTime() {
        return this.lastCollectTime.get();
    }

    protected abstract void getValueInternal();
}

