/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.edas.acm;

import com.alibaba.csp.ahas.shaded.com.alibaba.edas.acm.domain.ConfigKey;
import com.alibaba.csp.ahas.shaded.com.alibaba.edas.acm.exception.ConfigException;
import com.alibaba.csp.ahas.shaded.com.alibaba.edas.acm.filter.IACMConfigFilter;
import com.alibaba.csp.ahas.shaded.com.alibaba.edas.acm.filter.KMSConfigFilter;
import com.alibaba.csp.ahas.shaded.com.alibaba.edas.acm.filter.KMSFilterConfig;
import com.alibaba.csp.ahas.shaded.com.alibaba.edas.acm.listener.ConfigChangeListenerAdapter;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.client.Diamond;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.client.impl.DiamondEnvRepo;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.client.impl.ServerHttpAgent;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.client.impl.TenantUtil;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.config.STSConfig;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.exception.DiamondException;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.identify.CredentialService;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.utils.JSONUtils;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.utils.StringUtils;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

public class ConfigService {
    public static void init(String endpoint, String namespace, String accessKey, String secretKey) {
        Properties pp = new Properties();
        if (StringUtils.isNotEmpty(endpoint)) {
            pp.put("endpoint", endpoint);
        }
        if (StringUtils.isNotEmpty(namespace)) {
            pp.put("namespace", namespace);
        }
        if (StringUtils.isNotEmpty(accessKey)) {
            pp.put("accessKey", accessKey);
        }
        if (StringUtils.isNotEmpty(secretKey)) {
            pp.put("secretKey", secretKey);
        }
        ConfigService.init(pp);
    }

    public static void init() {
    }

    public static void init(Properties pp) {
        String cacheSecurityCredentials;
        String securityCredentialsUrl;
        String timeToRefreshInMillisecond;
        boolean openKMSFilter;
        String securityCredentials;
        String ramRoleName;
        String userTenant;
        String domainName;
        String endpoint = (String)pp.get("endpoint");
        String namespace = (String)pp.get("namespace");
        String accessKey = (String)pp.get("accessKey");
        String secretKey = (String)pp.get("secretKey");
        if (StringUtils.isNotEmpty(endpoint) && StringUtils.isBlank(domainName = System.getenv("ahas_address_server_domain")) && StringUtils.isBlank(domainName = System.getProperty("ahas.address.server.domain"))) {
            ServerHttpAgent.domainName = endpoint;
        }
        if (StringUtils.isNotEmpty(namespace) && StringUtils.isBlank(userTenant = System.getProperty("tenant.id", ""))) {
            TenantUtil.setUserTenant(namespace);
        }
        if (StringUtils.isNotEmpty(accessKey) && StringUtils.isBlank(CredentialService.getInstance().getCredential().getAccessKey())) {
            CredentialService.getInstance().getCredential().setAccessKey(accessKey);
        }
        if (StringUtils.isNotEmpty(secretKey) && StringUtils.isBlank(CredentialService.getInstance().getCredential().getSecretKey())) {
            CredentialService.getInstance().getCredential().setSecretKey(secretKey);
        }
        if (!StringUtils.isBlank(ramRoleName = (String)pp.get("ramRoleName")) && StringUtils.isBlank(System.getProperty("ram.role.name"))) {
            STSConfig.getInstance().setRamRoleName(ramRoleName);
        }
        if (!StringUtils.isBlank(securityCredentials = (String)pp.get("securityCredentials")) && StringUtils.isBlank(System.getProperty("security.credentials"))) {
            STSConfig.getInstance().setSecurityCredentials(securityCredentials);
        }
        boolean bl = openKMSFilter = pp.get("openKMSFilter") == null ? false : (Boolean)pp.get("openKMSFilter");
        if (openKMSFilter) {
            KMSConfigFilter kmsConfigFilter = new KMSConfigFilter();
            KMSFilterConfig filterConfig = new KMSFilterConfig();
            filterConfig.addInitParamter("keyId", pp.get("keyId"));
            filterConfig.addInitParamter("regionId", pp.get("regionId"));
            filterConfig.addInitParamter("ramRoleName", STSConfig.getInstance().getRamRoleName());
            filterConfig.addInitParamter("accessKey", accessKey);
            filterConfig.addInitParamter("secretKey", secretKey);
            if (!StringUtils.isBlank(securityCredentials)) {
                filterConfig.addInitParamter("securityCredentials", securityCredentials);
            }
            kmsConfigFilter.init(filterConfig);
            ConfigService.addConfigFilter(kmsConfigFilter);
        }
        if (!StringUtils.isBlank(timeToRefreshInMillisecond = (String)pp.get("timeToRefreshInMillisecond")) && StringUtils.isBlank(System.getProperty("time.to.refresh.in.millisecond"))) {
            STSConfig.getInstance().setTimeToRefreshInMillisecond(Integer.parseInt(timeToRefreshInMillisecond));
        }
        if (!StringUtils.isBlank(securityCredentialsUrl = (String)pp.get("securityCredentialsUrl")) && StringUtils.isBlank(System.getProperty("security.credentials.url"))) {
            STSConfig.getInstance().setSecurityCredentialsUrl(securityCredentialsUrl);
        }
        if (!StringUtils.isBlank(cacheSecurityCredentials = (String)pp.get("cacheSecurityCredentials")) && StringUtils.isBlank(System.getProperty("cache.security.credentials"))) {
            STSConfig.getInstance().setCacheSecurityCredentials(Boolean.valueOf(cacheSecurityCredentials));
        }
    }

    public static void addListener(String dataId, String group, ConfigChangeListenerAdapter listener) {
        DiamondEnvRepo.getDefaultEnv().addTenantListeners(dataId, group, Arrays.asList(listener));
    }

    public static void addGlobalListener(String dataId, String group, ConfigChangeListenerAdapter listener) {
        DiamondEnvRepo.getDefaultEnv().addListeners(dataId, group, Arrays.asList(listener));
    }

    public static String getConfig(String dataId, String group, long timeoutMs) throws ConfigException {
        try {
            return DiamondEnvRepo.getDefaultEnv().getTenantConfig(dataId, group, timeoutMs);
        }
        catch (DiamondException e) {
            throw new ConfigException(e.getErrCode(), e.getErrMsg(), e);
        }
    }

    public static Properties getConfig2Properties(String dataId, String group, long timeoutMs) throws ConfigException {
        Properties properties = new Properties();
        try {
            String content = DiamondEnvRepo.getDefaultEnv().getTenantConfig(dataId, group, timeoutMs);
            try {
                properties.load(new StringReader(content));
            }
            catch (IOException e) {
                throw new ConfigException(e.getMessage());
            }
        }
        catch (DiamondException diamondException) {
            throw new ConfigException(diamondException.getErrCode(), diamondException.getErrMsg(), diamondException);
        }
        return properties;
    }

    public static List<ConfigKey> getConfigs(long timeoutMs) throws ConfigException {
        try {
            List<com.alibaba.csp.ahas.shaded.com.taobao.diamond.domain.ConfigKey> configKeys = Diamond.getAllTenantConfig(timeoutMs);
            ArrayList<ConfigKey> configs = new ArrayList<ConfigKey>();
            for (com.alibaba.csp.ahas.shaded.com.taobao.diamond.domain.ConfigKey configKey : configKeys) {
                ConfigKey config = new ConfigKey(configKey.getDataId(), configKey.getGroup());
                configs.add(config);
            }
            return configs;
        }
        catch (DiamondException diamondException) {
            throw new ConfigException(diamondException.getErrCode(), diamondException.getErrMsg(), diamondException);
        }
    }

    public static Object getConfig(String dataId, String group, long timeoutMs, Class<?> clazz) throws ConfigException {
        try {
            String jsonStr = DiamondEnvRepo.getDefaultEnv().getTenantConfig(dataId, group, timeoutMs);
            Object result = JSONUtils.deserializeObject(jsonStr, clazz);
            return result;
        }
        catch (IOException e) {
            throw new ConfigException(e.getMessage());
        }
        catch (DiamondException diamondException) {
            throw new ConfigException(diamondException.getErrCode(), diamondException.getErrMsg(), diamondException);
        }
    }

    public static void addConfigFilter(IACMConfigFilter configFilter) {
        DiamondEnvRepo.getDefaultEnv().addConfigFilter(configFilter);
    }

    public static boolean publishConfig(String dataId, String group, String content) throws ConfigException {
        try {
            return DiamondEnvRepo.getDefaultEnv().publishTenantSingle(dataId, group, content);
        }
        catch (DiamondException e) {
            throw new ConfigException(e.getErrCode(), e.getErrMsg(), e);
        }
    }

    public static boolean removeConfig(String dataId, String group) throws ConfigException {
        try {
            return DiamondEnvRepo.getDefaultEnv().removeTenantConfig(dataId, group);
        }
        catch (DiamondException e) {
            throw new ConfigException(e.getErrCode(), e.getErrMsg(), e);
        }
    }
}

