/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Gauge;

public abstract class RatioGauge
implements Gauge<Double> {
    private long lastUpdated = System.currentTimeMillis();

    protected abstract Ratio getRatio();

    @Override
    public Double getValue() {
        try {
            Ratio r = this.getRatio();
            if (r == null) {
                return -10001.0;
            }
            double result = r.getValue();
            this.lastUpdated = System.currentTimeMillis();
            return result;
        }
        catch (Exception e) {
            return -10001.0;
        }
    }

    @Override
    public long lastUpdateTime() {
        return this.lastUpdated;
    }

    public static class Ratio {
        private final double numerator;
        private final double denominator;

        public static Ratio of(double numerator, double denominator) {
            return new Ratio(numerator, denominator);
        }

        private Ratio(double numerator, double denominator) {
            this.numerator = numerator;
            this.denominator = denominator;
        }

        public double getValue() {
            double d = this.denominator;
            if (Double.isNaN(d) || Double.isInfinite(d) || d == 0.0) {
                return Double.NaN;
            }
            return this.numerator / d;
        }

        public String toString() {
            return this.numerator + ":" + this.denominator;
        }
    }
}

