/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.integrate;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.IMetricManager;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Metric;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricManager;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricName;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricRegistry;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.integrate.MetricsIntegrateUtils;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.integrate.NamedThreadFactory;
import com.alibaba.csp.ahas.shaded.org.slf4j.Logger;
import com.alibaba.csp.ahas.shaded.org.slf4j.LoggerFactory;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class MetricsCleaner {
    private static final Logger log = LoggerFactory.getLogger(MetricsIntegrateUtils.class);
    private ScheduledExecutorService cleanerExecutor;
    private int keepInterval;
    private int delay;

    public MetricsCleaner(int keepInterval, int delay) {
        this.keepInterval = keepInterval;
        this.delay = delay;
        this.cleanerExecutor = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("cleaner"));
    }

    public void start() {
        this.cleanerExecutor.scheduleWithFixedDelay(new CleanTask(this.keepInterval), this.delay, this.delay, TimeUnit.SECONDS);
    }

    public void stop() {
        this.cleanerExecutor.shutdown();
        try {
            if (!this.cleanerExecutor.awaitTermination(this.delay * 2, TimeUnit.SECONDS)) {
                this.cleanerExecutor.shutdownNow();
                if (!this.cleanerExecutor.awaitTermination(this.delay * 2, TimeUnit.SECONDS)) {
                    log.warn(this.getClass().getSimpleName() + ": ScheduledExecutorService did not terminate.");
                }
            }
        }
        catch (InterruptedException ie) {
            this.cleanerExecutor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private static class CleanTask
    extends Thread {
        private long keepInterval;

        public CleanTask(int keepInterval) {
            this.keepInterval = 1000L * (long)keepInterval;
        }

        @Override
        public void run() {
            int cleanCount = 0;
            IMetricManager manager = MetricManager.getIMetricManager();
            for (String groupName : manager.listMetricGroups()) {
                MetricRegistry registry = manager.getMetricRegistryByGroup(groupName);
                Map<MetricName, Metric> metrics = registry.getMetrics();
                long curTs = System.currentTimeMillis();
                for (Map.Entry<MetricName, Metric> entry : metrics.entrySet()) {
                    try {
                        if (curTs - entry.getValue().lastUpdateTime() <= this.keepInterval || !registry.remove(entry.getKey())) continue;
                        log.info("Removed: {}", (Object)entry.getKey());
                        ++cleanCount;
                    }
                    catch (Throwable throwable) {}
                }
            }
            log.info("Clean up metrics count: {}", (Object)cleanCount);
        }
    }
}

