/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.integrate;

import com.alibaba.csp.ahas.shaded.com.alibaba.fastjson.JSONReader;
import com.alibaba.csp.ahas.shaded.com.alibaba.fastjson.JSONWriter;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.CachedMetricSet;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricLevel;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricManager;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricName;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.StringUtils;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.druid.DruidMetricsGaugeSet;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.integrate.ConfigFields;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.integrate.MetricsCleaner;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.integrate.ScrapeConfig;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.jvm.BufferPoolMetricSet;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.jvm.ClassLoadingGaugeSet;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.jvm.CompilationGauge;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.jvm.FileDescriptorGauge;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.jvm.FileDescriptorRatioGauge;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.jvm.GarbageCollectorMetricSet;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.jvm.JvmAttributeGaugeSet;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.jvm.MemoryUsageGaugeSet;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.jvm.ThreadStatesGaugeSet;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.nginx.NginxGaugeSet;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.os.linux.CpuUsageGaugeSet;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.os.linux.DiskStatGaugeSet;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.os.linux.NetTrafficGaugeSet;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.os.linux.TcpGaugeSet;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.os.utils.SystemInfoUtils;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.os.windows.SystemLoadGaugeSet;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.os.windows.SystemMemoryGaugeSet;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.tomcat.HttpGaugeSet;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.tomcat.ThreadGaugeSet;
import com.alibaba.csp.ahas.shaded.org.slf4j.Logger;
import com.alibaba.csp.ahas.shaded.org.slf4j.LoggerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.lang.management.ManagementFactory;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.TimeUnit;

public class MetricsIntegrateUtils {
    private static final Logger log = LoggerFactory.getLogger(MetricsIntegrateUtils.class);
    private static final String DEFAULT_SCRAPE_FILE = ".ali_metrics_scrape_config";
    private static MetricsCleaner metricsCleaner = null;

    public static void registerJvmMetrics(Properties metricsConfig) {
        if (MetricsIntegrateUtils.isEnabled(metricsConfig, ConfigFields.JVM_MEM_FIELD)) {
            MetricLevel jvmMemLevel = MetricsIntegrateUtils.parseMetricLevel(metricsConfig, ConfigFields.JVM_MEM_LEVEL_FIELD, ConfigFields.JVM_MEM_LEVEL);
            MetricManager.register("jvm", MetricName.build("jvm.mem").level(jvmMemLevel), new MemoryUsageGaugeSet());
        }
        if (MetricsIntegrateUtils.isEnabled(metricsConfig, ConfigFields.JVM_GC_FIELD)) {
            MetricLevel jvmGcLevel = MetricsIntegrateUtils.parseMetricLevel(metricsConfig, ConfigFields.JVM_GC_LEVEL_FIELD, ConfigFields.JVM_GC_LEVEL);
            MetricManager.register("jvm", MetricName.build("jvm.gc").level(jvmGcLevel), new GarbageCollectorMetricSet());
        }
        if (MetricsIntegrateUtils.isEnabled(metricsConfig, ConfigFields.JVM_CLASS_LOAD_FIELD)) {
            MetricLevel jvmClassLoadLevel = MetricsIntegrateUtils.parseMetricLevel(metricsConfig, ConfigFields.JVM_CLASS_LOAD_LEVEL_FIELD, ConfigFields.JVM_CLASS_LOAD_LEVEL);
            MetricManager.register("jvm", MetricName.build("jvm.class_load").level(jvmClassLoadLevel), new ClassLoadingGaugeSet());
        }
        if (MetricsIntegrateUtils.isEnabled(metricsConfig, ConfigFields.JVM_BUFFER_POOL_FIELD)) {
            MetricLevel jvmBufferPoolLevel = MetricsIntegrateUtils.parseMetricLevel(metricsConfig, ConfigFields.JVM_BUFFER_POOL_LEVEL_FIELD, ConfigFields.JVM_BUFFER_POOL_LEVEL);
            MetricManager.register("jvm", MetricName.build("jvm.buffer_pool").level(jvmBufferPoolLevel), new BufferPoolMetricSet(ManagementFactory.getPlatformMBeanServer()));
        }
        if (MetricsIntegrateUtils.isEnabled(metricsConfig, ConfigFields.JVM_FILE_DESC_FIELD)) {
            MetricLevel jvmFileDescLevel = MetricsIntegrateUtils.parseMetricLevel(metricsConfig, ConfigFields.JVM_FILE_DESC_LEVEL_FIELD, ConfigFields.JVM_FILE_DESC_LEVEL);
            MetricManager.register("jvm", MetricName.build("jvm.file_descriptor.open_ratio").level(jvmFileDescLevel), new FileDescriptorRatioGauge(ManagementFactory.getOperatingSystemMXBean(), MetricsIntegrateUtils.cachedTimeForLevel(jvmFileDescLevel), TimeUnit.SECONDS));
            MetricManager.register("jvm", MetricName.build("jvm.file_descriptor.open_count").level(jvmFileDescLevel), new FileDescriptorGauge(MetricsIntegrateUtils.cachedTimeForLevel(jvmFileDescLevel), TimeUnit.SECONDS, ManagementFactory.getOperatingSystemMXBean()));
        }
        if (MetricsIntegrateUtils.isEnabled(metricsConfig, ConfigFields.JVM_THREAD_STATE_FIELD)) {
            MetricLevel jvmThreadStateLevel = MetricsIntegrateUtils.parseMetricLevel(metricsConfig, ConfigFields.JVM_THREAD_STATE_LEVEL_FIELD, MetricLevel.TRIVIAL);
            MetricManager.register("jvm", MetricName.build("jvm.thread").level(jvmThreadStateLevel), new ThreadStatesGaugeSet(MetricsIntegrateUtils.cachedTimeForLevel(jvmThreadStateLevel), TimeUnit.SECONDS));
        }
        if (MetricsIntegrateUtils.isEnabled(metricsConfig, ConfigFields.JVM_COMPILATION_FIELD)) {
            MetricLevel jvmCompilationLevel = MetricsIntegrateUtils.parseMetricLevel(metricsConfig, ConfigFields.JVM_COMPILATION_LEVEL_FIELD, MetricLevel.TRIVIAL);
            MetricManager.register("jvm", MetricName.build("jvm.compilation.delta_time").level(jvmCompilationLevel), new CompilationGauge(MetricsIntegrateUtils.cachedTimeForLevel(jvmCompilationLevel), TimeUnit.SECONDS));
        }
    }

    public static void registerJvmAttributeMetrics(Properties metricsConfig) {
        MetricManager.register("jvm", MetricName.build("jvm.runtime"), new JvmAttributeGaugeSet());
    }

    public static void registerSystemMetrics(Properties metricsConfig) {
        CachedMetricSet metric;
        SystemInfoUtils.init();
        if (MetricsIntegrateUtils.isEnabled(metricsConfig, ConfigFields.SYSTEM_LOAD_FIELD)) {
            MetricLevel loadLevel = MetricsIntegrateUtils.parseMetricLevel(metricsConfig, ConfigFields.SYSTEM_LOAD_LEVEL_FIELD, ConfigFields.SYSTEM_LOAD_LEVEL);
            metric = null;
            metric = !SystemInfoUtils.needLoad() ? new com.alibaba.csp.ahas.shaded.com.alibaba.metrics.os.linux.SystemLoadGaugeSet(MetricsIntegrateUtils.cachedTimeForLevel(loadLevel), TimeUnit.SECONDS) : new SystemLoadGaugeSet(MetricsIntegrateUtils.cachedTimeForLevel(loadLevel), TimeUnit.SECONDS);
            MetricManager.register("system", MetricName.build("system").level(loadLevel), metric);
        }
        if (MetricsIntegrateUtils.isEnabled(metricsConfig, ConfigFields.SYSTEM_CPU_FIELD)) {
            MetricLevel cpuLevel = MetricsIntegrateUtils.parseMetricLevel(metricsConfig, ConfigFields.SYSTEM_CPU_LEVEL_FIELD, ConfigFields.SYSTEM_CPU_LEVEL);
            metric = null;
            metric = !SystemInfoUtils.needLoad() ? new CpuUsageGaugeSet(MetricsIntegrateUtils.cachedTimeForLevel(cpuLevel), TimeUnit.SECONDS) : new com.alibaba.csp.ahas.shaded.com.alibaba.metrics.os.windows.CpuUsageGaugeSet(MetricsIntegrateUtils.cachedTimeForLevel(cpuLevel), TimeUnit.SECONDS);
            MetricManager.register("system", MetricName.build("system").level(cpuLevel), metric);
        }
        if (MetricsIntegrateUtils.isEnabled(metricsConfig, ConfigFields.SYSTEM_NET_FIELD)) {
            MetricLevel netLevel = MetricsIntegrateUtils.parseMetricLevel(metricsConfig, ConfigFields.SYSTEM_NET_LEVEL_FIELD, ConfigFields.SYSTEM_NET_LEVEL);
            MetricManager.register("system", MetricName.build("system").level(netLevel), new NetTrafficGaugeSet(MetricsIntegrateUtils.cachedTimeForLevel(netLevel), TimeUnit.SECONDS));
        }
        if (MetricsIntegrateUtils.isEnabled(metricsConfig, ConfigFields.SYSTEM_MEMORY_FIELD)) {
            MetricLevel memLevel = MetricsIntegrateUtils.parseMetricLevel(metricsConfig, ConfigFields.SYSTEM_MEMORY_LEVEL_FIELD, ConfigFields.SYSTEM_MEMORY_LEVEL);
            metric = null;
            metric = !SystemInfoUtils.needLoad() ? new com.alibaba.csp.ahas.shaded.com.alibaba.metrics.os.linux.SystemMemoryGaugeSet(MetricsIntegrateUtils.cachedTimeForLevel(memLevel), TimeUnit.SECONDS) : new SystemMemoryGaugeSet(MetricsIntegrateUtils.cachedTimeForLevel(memLevel), TimeUnit.SECONDS);
            MetricManager.register("system", MetricName.build("system").level(memLevel), metric);
        }
        if (MetricsIntegrateUtils.isEnabled(metricsConfig, ConfigFields.SYSTEM_TCP_FIELD)) {
            MetricLevel tcpLevel = MetricsIntegrateUtils.parseMetricLevel(metricsConfig, ConfigFields.SYSTEM_TCP_LEVEL_FIELD, ConfigFields.SYSTEM_TCP_LEVEL);
            MetricManager.register("system", MetricName.build("system").level(tcpLevel), new TcpGaugeSet(MetricsIntegrateUtils.cachedTimeForLevel(tcpLevel), TimeUnit.SECONDS));
        }
        if (MetricsIntegrateUtils.isEnabled(metricsConfig, ConfigFields.SYSTEM_DISK_FIELD)) {
            MetricLevel diskLevel = MetricsIntegrateUtils.parseMetricLevel(metricsConfig, ConfigFields.SYSTEM_DISK_LEVEL_FIELD, ConfigFields.SYSTEM_DISK_LEVEL);
            MetricManager.register("system", MetricName.build("system").level(diskLevel), new DiskStatGaugeSet(MetricsIntegrateUtils.cachedTimeForLevel(diskLevel), TimeUnit.SECONDS));
        }
    }

    public static void registerTomcatMetrics(Properties metricsConfig) {
        if (MetricsIntegrateUtils.isEnabled(metricsConfig, ConfigFields.TOMCAT_HTTP_FIELD)) {
            MetricLevel httpLevel = MetricsIntegrateUtils.parseMetricLevel(metricsConfig, ConfigFields.TOMCAT_HTTP_LEVEL_FIELD, ConfigFields.TOMCAT_HTTP_LEVEL);
            MetricManager.register("tomcat", MetricName.build("middleware.tomcat.http").level(httpLevel), new HttpGaugeSet(MetricsIntegrateUtils.cachedTimeForLevel(httpLevel), TimeUnit.SECONDS));
        }
        if (MetricsIntegrateUtils.isEnabled(metricsConfig, ConfigFields.TOMCAT_THREAD_FIELD)) {
            MetricLevel theadLevel = MetricsIntegrateUtils.parseMetricLevel(metricsConfig, ConfigFields.TOMCAT_THREAD_LEVEL_FIELD, ConfigFields.TOMCAT_THREAD_LEVEL);
            MetricManager.register("tomcat", MetricName.build("middleware.tomcat.thread").level(theadLevel), new ThreadGaugeSet(MetricsIntegrateUtils.cachedTimeForLevel(theadLevel), TimeUnit.SECONDS));
        }
    }

    public static void registerNginxMetrics(Properties metricsConfig) {
        if (MetricsIntegrateUtils.isEnabled(metricsConfig, ConfigFields.NGINX_FIELD)) {
            MetricLevel nginxLevel = MetricsIntegrateUtils.parseMetricLevel(metricsConfig, ConfigFields.NGINX_LEVEL_FIELD, ConfigFields.NGINX_LEVEL);
            MetricManager.register("nginx", MetricName.build("middleware.nginx").level(nginxLevel), new NginxGaugeSet(MetricsIntegrateUtils.cachedTimeForLevel(nginxLevel), TimeUnit.SECONDS));
        }
    }

    public static void registerDruidMetrics(Properties metricsConfig) {
        if ("true".equals(metricsConfig.getProperty("com.alibaba.csp.ahas.shaded.com.alibaba.metrics.druid.forceTurnOnStats"))) {
            String druidFilters = System.getProperty("druid.filters");
            if (StringUtils.isBlank(druidFilters)) {
                druidFilters = "stat";
            } else if (!druidFilters.contains("stat")) {
                druidFilters = druidFilters + ",stat";
            }
            System.setProperty("druid.filters", druidFilters);
            System.setProperty("druid.stat.mergeSql", "true");
            System.setProperty("druid.useGlobalDataSourceStat", "true");
        }
        if (MetricsIntegrateUtils.isEnabled(metricsConfig, ConfigFields.DRUID_FIELD, ConfigFields.DRUID_DEFAULT)) {
            MetricLevel druidLevel = MetricsIntegrateUtils.parseMetricLevel(metricsConfig, ConfigFields.DRUID_LEVEL_FIELD, ConfigFields.DRUID_LEVEL);
            MetricName baseName = MetricName.build("druid.sql").level(druidLevel);
            MetricManager.register("druid", baseName, new DruidMetricsGaugeSet((long)MetricsIntegrateUtils.cachedTimeForLevel(druidLevel), TimeUnit.SECONDS, baseName));
        }
    }

    public static void registerAll() {
        MetricsIntegrateUtils.registerAllMetrics(new Properties());
    }

    public static void registerMetrics(String configFile) {
        Properties prop = MetricsIntegrateUtils.parsePropertiesFromFile(configFile);
        MetricsIntegrateUtils.registerAllMetrics(prop);
    }

    public static void registerAllMetrics(Properties metricsConfig) {
        try {
            MetricsIntegrateUtils.registerSystemMetrics(metricsConfig);
        }
        catch (Exception e) {
            log.error("Register system metrics failed: ", e);
        }
        try {
            MetricsIntegrateUtils.registerJvmMetrics(metricsConfig);
        }
        catch (Exception e) {
            log.error("Register jvm metrics failed: ", e);
        }
        try {
            MetricsIntegrateUtils.registerTomcatMetrics(metricsConfig);
        }
        catch (Exception e) {
            log.error("Register tomcat metrics failed: ", e);
        }
        try {
            MetricsIntegrateUtils.registerNginxMetrics(metricsConfig);
        }
        catch (Exception e) {
            log.error("Register nginx metrics failed: ", e);
        }
        try {
            MetricsIntegrateUtils.registerDruidMetrics(metricsConfig);
        }
        catch (Exception e) {
            log.error("Register druid metrics failed: ", e);
        }
        MetricsIntegrateUtils.generateScrapeConfigFile("/tmp" + File.separator + DEFAULT_SCRAPE_FILE);
    }

    public static void startMetricsCleaner(Properties metricsConfig) {
        if (MetricsIntegrateUtils.isEnabled(metricsConfig, ConfigFields.METRICS_CLEANER_ENABLE)) {
            int keepInterval = MetricsIntegrateUtils.parseInteger(metricsConfig, ConfigFields.METRICS_CLEANER_KEEP_INTERVAL, ConfigFields.METRICS_CLEANER_DEFAULT_KEEP_INTERVAL);
            int delay = MetricsIntegrateUtils.parseInteger(metricsConfig, ConfigFields.METRICS_CLEANER_DELAY, ConfigFields.METRICS_CLEANER_DEFAULT_DELAY);
            if (metricsCleaner == null) {
                metricsCleaner = new MetricsCleaner(keepInterval, delay);
                metricsCleaner.start();
            }
        }
    }

    public static void stopMetricsCleaner() {
        if (metricsCleaner != null) {
            metricsCleaner.stop();
            metricsCleaner = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties parsePropertiesFromFile(String configFile) {
        Properties prop = new Properties();
        if (configFile == null) {
            return prop;
        }
        FileInputStream input = null;
        try {
            input = new FileInputStream(configFile);
            prop.load(input);
        }
        catch (IOException e) {
            log.error("Error when loading property file:", e);
        }
        finally {
            if (input != null) {
                try {
                    ((InputStream)input).close();
                }
                catch (IOException iOException) {}
            }
        }
        return prop;
    }

    public static boolean isEnabled(Properties config, String input) {
        return MetricsIntegrateUtils.isEnabled(config, input, true);
    }

    public static boolean isEnabled(Properties config, String input, boolean defaultValue) {
        String data2;
        try {
            data2 = System.getProperty(input);
            if (data2 != null) {
                return Boolean.parseBoolean(data2);
            }
        }
        catch (Exception data2) {
            // empty catch block
        }
        try {
            data2 = System.getenv().get(input);
            if (data2 != null) {
                return Boolean.parseBoolean(data2);
            }
        }
        catch (Exception data3) {
            // empty catch block
        }
        try {
            data2 = config.getProperty(input);
            if (data2 != null) {
                return Boolean.parseBoolean(data2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean generateScrapeConfigFile(String fileName) {
        Integer port = Integer.getInteger("tomcat.monitor.http.port");
        if (port == null) {
            port = Integer.getInteger("com.alibaba.csp.ahas.shaded.com.alibaba.metrics.http.port");
        }
        if (port == null) {
            port = Integer.getInteger("management.port");
        }
        if (port == null) {
            log.warn("Could not find http port, skipping scrape file generation.");
            return false;
        }
        ArrayList<ScrapeConfig> configs = new ArrayList<ScrapeConfig>();
        boolean found = false;
        File pathFile = new File(fileName);
        if (!pathFile.exists()) {
            try {
                pathFile.createNewFile();
            }
            catch (IOException e) {
                log.error("Error when creating scrape config file", e);
                return false;
            }
        }
        if (pathFile.length() > 0L) {
            try {
                JSONReader reader = new JSONReader(new FileReader(fileName));
                reader.startArray();
                while (reader.hasNext()) {
                    ScrapeConfig config = reader.readObject(ScrapeConfig.class);
                    configs.add(config);
                    if (config.getPort() != port.intValue()) continue;
                    found = true;
                }
                reader.endArray();
                reader.close();
            }
            catch (Exception e) {
                log.error("Error when reading scrape config file", e);
                return false;
            }
        }
        RandomAccessFile raf = null;
        FileLock fileLock = null;
        try {
            raf = new RandomAccessFile(pathFile, "rw");
            fileLock = raf.getChannel().tryLock();
            if (fileLock == null) {
                log.info("The scrape config file is locked by another process, fail fast.");
                return false;
            }
        }
        catch (Exception e) {
            log.error("Error when locking scrape config file", e);
            return false;
        }
        try {
            if (!found) {
                ScrapeConfig newConfig = new ScrapeConfig(port, "http://127.0.0.1:" + port + "/metrics/search");
                newConfig.build();
                configs.add(newConfig);
                JSONWriter writer = new JSONWriter(new FileWriter(fileName));
                writer.startArray();
                for (ScrapeConfig config : configs) {
                    writer.writeValue(config);
                }
                writer.endArray();
                writer.close();
            }
            boolean newConfig = true;
            return newConfig;
        }
        catch (Exception e) {
            log.error("Error when writing scrape config file", e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                fileLock.release();
                raf.close();
            }
            catch (Exception e) {
                log.error("Error when closing scrape config file", e);
            }
        }
    }

    private static MetricLevel parseMetricLevel(Properties config, String level, MetricLevel defaultLevel) {
        try {
            return MetricLevel.valueOf(config.getProperty(level));
        }
        catch (Exception e) {
            return defaultLevel;
        }
    }

    private static int parseInteger(Properties config, String input, int defaultValue) {
        try {
            return Integer.parseInt(config.getProperty(input));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private static int cachedTimeForLevel(MetricLevel level) {
        switch (level) {
            case TRIVIAL: {
                return 50;
            }
            case MINOR: {
                return 20;
            }
            case NORMAL: {
                return 10;
            }
            case MAJOR: {
                return 2;
            }
            case CRITICAL: {
                return 1;
            }
        }
        return 50;
    }
}

