/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.jvm;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.CachedGauge;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;

public class FileDescriptorGauge
extends CachedGauge<Long> {
    private final OperatingSystemMXBean os;

    public FileDescriptorGauge(long timeout, TimeUnit timeoutUnit) {
        super(timeout, timeoutUnit);
        this.os = ManagementFactory.getOperatingSystemMXBean();
    }

    public FileDescriptorGauge(long timeout, TimeUnit timeoutUnit, OperatingSystemMXBean os) {
        super(timeout, timeoutUnit);
        this.os = os;
    }

    @Override
    protected Long loadValue() {
        try {
            return this.invoke("getOpenFileDescriptorCount");
        }
        catch (Throwable e) {
            return 0L;
        }
    }

    private long invoke(String name) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method = this.os.getClass().getDeclaredMethod(name, new Class[0]);
        method.setAccessible(true);
        return (Long)method.invoke((Object)this.os, new Object[0]);
    }
}

