/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.jvm;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Metric;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricName;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricSet;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.PersistentGauge;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class JvmAttributeGaugeSet
implements MetricSet {
    private final RuntimeMXBean runtime;

    public JvmAttributeGaugeSet() {
        this(ManagementFactory.getRuntimeMXBean());
    }

    public JvmAttributeGaugeSet(RuntimeMXBean runtime) {
        this.runtime = runtime;
    }

    @Override
    public Map<MetricName, Metric> getMetrics() {
        HashMap<MetricName, PersistentGauge> gauges = new HashMap<MetricName, PersistentGauge>();
        gauges.put(MetricName.build("name"), new PersistentGauge<String>(){

            @Override
            public String getValue() {
                return JvmAttributeGaugeSet.this.runtime.getName();
            }
        });
        gauges.put(MetricName.build("vendor"), new PersistentGauge<String>(){

            @Override
            public String getValue() {
                return String.format(Locale.US, "%s %s %s (%s)", JvmAttributeGaugeSet.this.runtime.getVmVendor(), JvmAttributeGaugeSet.this.runtime.getVmName(), JvmAttributeGaugeSet.this.runtime.getVmVersion(), JvmAttributeGaugeSet.this.runtime.getSpecVersion());
            }
        });
        gauges.put(MetricName.build("uptime"), new PersistentGauge<Long>(){

            @Override
            public Long getValue() {
                return JvmAttributeGaugeSet.this.runtime.getUptime();
            }
        });
        return Collections.unmodifiableMap(gauges);
    }

    @Override
    public long lastUpdateTime() {
        return System.currentTimeMillis();
    }
}

