/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.os.linux;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.CachedMetricSet;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Clock;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Metric;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricName;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.PersistentGauge;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.os.utils.FileUtils;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.os.utils.FormatUtils;
import com.alibaba.csp.ahas.shaded.org.slf4j.Logger;
import com.alibaba.csp.ahas.shaded.org.slf4j.LoggerFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CpuUsageGaugeSet
extends CachedMetricSet {
    private static final Logger logger = LoggerFactory.getLogger(CpuUsageGaugeSet.class);
    private static final String DELIM = "\\s+";
    private static final Pattern cpuStatPattern = Pattern.compile("^.*cpu\\s+([\\d]+)\\s+([\\d]+)\\s+([\\d]+)\\s+([\\d]+)\\s+([\\d]+)\\s+([\\d]+)\\s+([\\d]+)\\s+([\\d]+)\\s+([\\d]+).*$", 32);
    private static final String DEFAULT_FILE_PATH = "/proc/stat";
    private float[] cpuUsage;
    private CpuInfo lastCollectedCpuInfo;
    private String filePath;
    private int numOfProcessors;
    private long processRunning;
    private long processBlocked;
    private long totalInterrupts;
    private double interruptsRate;
    private long totalContextSwitches;
    private double contextSwitchesRate;
    private Map<MetricName, Metric> gauges = new HashMap<MetricName, Metric>();

    public CpuUsageGaugeSet() {
        this(DEFAULT_DATA_TTL, TimeUnit.MILLISECONDS, DEFAULT_FILE_PATH, Clock.defaultClock());
    }

    public CpuUsageGaugeSet(String filePath) {
        this(DEFAULT_DATA_TTL, TimeUnit.MILLISECONDS, filePath, Clock.defaultClock());
    }

    public CpuUsageGaugeSet(long dataTTL, TimeUnit unit) {
        this(dataTTL, unit, DEFAULT_FILE_PATH, Clock.defaultClock());
    }

    public CpuUsageGaugeSet(long dataTTL, TimeUnit unit, String filePath, Clock clock) {
        super(dataTTL, unit, clock);
        this.cpuUsage = new float[CpuUsage.values().length];
        this.lastCollectedCpuInfo = new CpuInfo();
        this.filePath = filePath;
        this.populateMetrics();
    }

    @Override
    public Map<MetricName, Metric> getMetrics() {
        return this.gauges;
    }

    @Override
    protected void getValueInternal() {
        List<String> lines;
        try {
            lines = FileUtils.readFileAsStringArray(this.filePath);
        }
        catch (Exception e) {
            logger.warn("Error during reading file {}", (Object)this.filePath, (Object)e);
            return;
        }
        int numOfProcessors = -1;
        String cpuLine = null;
        for (String line : lines) {
            long duration;
            Object data;
            if (line.startsWith("cpu")) {
                ++numOfProcessors;
                if (!line.startsWith("cpu ")) continue;
                cpuLine = line;
                continue;
            }
            if (line.startsWith("intr")) {
                try {
                    data = line.substring("intr ".length(), line.indexOf(32, "intr ".length()));
                    long latestIntr = Long.parseLong((String)data);
                    if (this.totalInterrupts == 0L) {
                        this.interruptsRate = 0.0;
                    } else if (latestIntr >= this.totalInterrupts) {
                        duration = this.clock.getTime() - this.lastCollectTime.get();
                        this.interruptsRate = 1000.0 * (double)(latestIntr - this.totalInterrupts) / (double)duration;
                    } else {
                        logger.warn("Invalid interrupt data, last collected {}, current {}, raw {}", this.totalInterrupts, latestIntr, line);
                        this.interruptsRate = -10001.0;
                    }
                    this.totalInterrupts = latestIntr;
                }
                catch (Exception e) {
                    this.interruptsRate = -10001.0;
                    logger.warn("Error parsing intr info: ", e);
                }
                continue;
            }
            if (line.startsWith("ctxt")) {
                try {
                    data = line.split(DELIM);
                    long latestCtxt = Long.parseLong(data[1]);
                    if (this.totalContextSwitches == 0L) {
                        this.contextSwitchesRate = 0.0;
                    } else if (latestCtxt >= this.totalContextSwitches) {
                        duration = this.clock.getTime() - this.lastCollectTime.get();
                        this.contextSwitchesRate = 1000.0 * (double)(latestCtxt - this.totalContextSwitches) / (double)duration;
                    } else {
                        logger.warn("Invalid context data, last collected {}, current {}, raw {}", this.totalContextSwitches, latestCtxt, line);
                        this.contextSwitchesRate = -10001.0;
                    }
                    this.totalContextSwitches = latestCtxt;
                }
                catch (Exception e) {
                    this.contextSwitchesRate = -10001.0;
                    logger.warn("Error parsing context switch info: ", e);
                }
                continue;
            }
            if (line.startsWith("procs_running")) {
                try {
                    data = line.split(DELIM);
                    this.processRunning = Long.parseLong(data[1]);
                }
                catch (NumberFormatException n) {
                    this.processRunning = -1L;
                    logger.warn("Invalid line of process running found, raw data: {}", (Object)line);
                }
                catch (Exception e) {
                    this.processRunning = -1L;
                    logger.warn("Error parsing process running info: ", e);
                }
                continue;
            }
            if (!line.startsWith("procs_blocked")) continue;
            try {
                data = line.split(DELIM);
                this.processBlocked = Long.parseLong(data[1]);
            }
            catch (Exception e) {
                this.processBlocked = -1L;
                logger.warn("Error parsing process blocked info: ", e);
            }
        }
        if (numOfProcessors > 0) {
            this.numOfProcessors = numOfProcessors;
        }
        if (cpuLine == null) {
            logger.error("Could not find cpu line, this should not happen");
            return;
        }
        try {
            CpuInfo current = this.collectCpuInfo(cpuLine);
            this.cpuUsage[CpuUsage.USER.ordinal()] = this.getUsage(current.userTime, this.lastCollectedCpuInfo.userTime, current, this.lastCollectedCpuInfo);
            this.cpuUsage[CpuUsage.NICE.ordinal()] = this.getUsage(current.niceTime, this.lastCollectedCpuInfo.niceTime, current, this.lastCollectedCpuInfo);
            this.cpuUsage[CpuUsage.SYSTEM.ordinal()] = this.getUsage(current.systemTime, this.lastCollectedCpuInfo.systemTime, current, this.lastCollectedCpuInfo);
            this.cpuUsage[CpuUsage.IDLE.ordinal()] = this.getUsage(current.idleTime, this.lastCollectedCpuInfo.idleTime, current, this.lastCollectedCpuInfo);
            this.cpuUsage[CpuUsage.IOWAIT.ordinal()] = this.getUsage(current.iowaitTime, this.lastCollectedCpuInfo.iowaitTime, current, this.lastCollectedCpuInfo);
            this.cpuUsage[CpuUsage.IRQ.ordinal()] = this.getUsage(current.irqTime, this.lastCollectedCpuInfo.irqTime, current, this.lastCollectedCpuInfo);
            this.cpuUsage[CpuUsage.SOFTIRQ.ordinal()] = this.getUsage(current.softirqTime, this.lastCollectedCpuInfo.softirqTime, current, this.lastCollectedCpuInfo);
            this.cpuUsage[CpuUsage.STEAL.ordinal()] = this.getUsage(current.stealTime, this.lastCollectedCpuInfo.stealTime, current, this.lastCollectedCpuInfo);
            this.cpuUsage[CpuUsage.GUEST.ordinal()] = this.getUsage(current.guestTIme, this.lastCollectedCpuInfo.guestTIme, current, this.lastCollectedCpuInfo);
            this.lastCollectedCpuInfo = current;
        }
        catch (Exception e) {
            logger.warn("Error parsing cpu info: ", e);
        }
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    private void populateMetrics() {
        this.gauges.put(MetricName.build("cpu.user"), new CpuGauge(CpuUsage.USER.ordinal()));
        this.gauges.put(MetricName.build("cpu.nice"), new CpuGauge(CpuUsage.NICE.ordinal()));
        this.gauges.put(MetricName.build("cpu.system"), new CpuGauge(CpuUsage.SYSTEM.ordinal()));
        this.gauges.put(MetricName.build("cpu.idle"), new CpuGauge(CpuUsage.IDLE.ordinal()));
        this.gauges.put(MetricName.build("cpu.iowait"), new CpuGauge(CpuUsage.IOWAIT.ordinal()));
        this.gauges.put(MetricName.build("cpu.irq"), new CpuGauge(CpuUsage.IRQ.ordinal()));
        this.gauges.put(MetricName.build("cpu.softirq"), new CpuGauge(CpuUsage.SOFTIRQ.ordinal()));
        this.gauges.put(MetricName.build("cpu.steal"), new CpuGauge(CpuUsage.STEAL.ordinal()));
        this.gauges.put(MetricName.build("cpu.guest"), new CpuGauge(CpuUsage.GUEST.ordinal()));
        this.gauges.put(MetricName.build("interrupts"), new PersistentGauge<Double>(){

            @Override
            public Double getValue() {
                CpuUsageGaugeSet.this.refreshIfNecessary();
                return CpuUsageGaugeSet.this.interruptsRate;
            }
        });
        this.gauges.put(MetricName.build("context_switches"), new PersistentGauge<Double>(){

            @Override
            public Double getValue() {
                CpuUsageGaugeSet.this.refreshIfNecessary();
                return CpuUsageGaugeSet.this.contextSwitchesRate;
            }
        });
        this.gauges.put(MetricName.build("process.running"), new PersistentGauge<Long>(){

            @Override
            public Long getValue() {
                CpuUsageGaugeSet.this.refreshIfNecessary();
                return CpuUsageGaugeSet.this.processRunning;
            }
        });
        this.gauges.put(MetricName.build("process.blocked"), new PersistentGauge<Long>(){

            @Override
            public Long getValue() {
                CpuUsageGaugeSet.this.refreshIfNecessary();
                return CpuUsageGaugeSet.this.processBlocked;
            }
        });
    }

    private CpuInfo collectCpuInfo(String statResult) {
        CpuInfo info = new CpuInfo();
        Matcher statMatcher = cpuStatPattern.matcher(statResult);
        if (statMatcher.matches()) {
            for (int i = 1; i <= statMatcher.groupCount(); ++i) {
                long time = Long.parseLong(statMatcher.group(i));
                switch (i) {
                    case 1: {
                        info.userTime = time;
                        break;
                    }
                    case 2: {
                        info.niceTime = time;
                        break;
                    }
                    case 3: {
                        info.systemTime = time;
                        break;
                    }
                    case 4: {
                        info.idleTime = time;
                        break;
                    }
                    case 5: {
                        info.iowaitTime = time;
                        break;
                    }
                    case 6: {
                        info.irqTime = time;
                        break;
                    }
                    case 7: {
                        info.softirqTime = time;
                        break;
                    }
                    case 8: {
                        info.stealTime = time;
                        break;
                    }
                    case 9: {
                        info.guestTIme = time;
                    }
                }
                info.totalTime += time;
            }
        }
        return info;
    }

    private float getUsage(long current, long last, CpuInfo curInfo, CpuInfo lastInfo) {
        try {
            int cpuShare = this.numOfProcessors;
            try {
                cpuShare = Integer.parseInt(System.getenv("LEGACY_CONTAINER_SIZE_CPU_COUNT"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            float f = 100.0f * (float)(current - last) * (float)this.numOfProcessors / (float)(curInfo.totalTime - lastInfo.totalTime) / (float)cpuShare;
            return FormatUtils.formatFloat(f);
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    private class CpuInfo {
        long userTime;
        long niceTime;
        long systemTime;
        long idleTime;
        long iowaitTime;
        long irqTime;
        long softirqTime;
        long stealTime;
        long guestTIme;
        long totalTime;

        private CpuInfo() {
        }
    }

    private class CpuGauge
    extends PersistentGauge<Float> {
        private int index;

        public CpuGauge(int index) {
            this.index = index;
        }

        @Override
        public Float getValue() {
            try {
                CpuUsageGaugeSet.this.refreshIfNecessary();
                return Float.valueOf(CpuUsageGaugeSet.this.cpuUsage[this.index]);
            }
            catch (Exception e) {
                return Float.valueOf(0.0f);
            }
        }
    }

    private static enum CpuUsage {
        USER,
        NICE,
        SYSTEM,
        IDLE,
        IOWAIT,
        IRQ,
        SOFTIRQ,
        STEAL,
        GUEST;

    }
}

