/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.os.linux;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.CachedMetricSet;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Metric;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricName;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.PersistentGauge;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.os.utils.FileUtils;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.os.utils.FormatUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SystemLoadGaugeSet
extends CachedMetricSet {
    private static final String DEFAULT_FILE_PATH = "/proc/loadavg";
    private static final Pattern loadPattern = Pattern.compile("^([\\d\\.]+)\\s+([\\d\\.]+)\\s+([\\d\\.]+)\\s+[\\d]+/[\\d]+\\s+([\\d]+).*$", 32);
    private float[] loadAvg = new float[LoadAvg.values().length];
    private String filePath;

    public SystemLoadGaugeSet() {
        this(DEFAULT_DATA_TTL, TimeUnit.MILLISECONDS, DEFAULT_FILE_PATH);
    }

    public SystemLoadGaugeSet(long dataTTL, TimeUnit unit) {
        this(dataTTL, unit, DEFAULT_FILE_PATH);
    }

    public SystemLoadGaugeSet(long dataTTL, TimeUnit unit, String filePath) {
        super(dataTTL, unit);
        this.filePath = filePath;
    }

    @Override
    public Map<MetricName, Metric> getMetrics() {
        HashMap<MetricName, Metric> gauges = new HashMap<MetricName, Metric>();
        gauges.put(MetricName.build("load.1min"), new PersistentGauge<Float>(){

            @Override
            public Float getValue() {
                SystemLoadGaugeSet.this.refreshIfNecessary();
                return Float.valueOf(SystemLoadGaugeSet.this.loadAvg[LoadAvg.ONE_MIN.ordinal()]);
            }
        });
        gauges.put(MetricName.build("load.5min"), new PersistentGauge<Float>(){

            @Override
            public Float getValue() {
                SystemLoadGaugeSet.this.refreshIfNecessary();
                return Float.valueOf(SystemLoadGaugeSet.this.loadAvg[LoadAvg.FIVE_MIN.ordinal()]);
            }
        });
        gauges.put(MetricName.build("load.15min"), new PersistentGauge<Float>(){

            @Override
            public Float getValue() {
                SystemLoadGaugeSet.this.refreshIfNecessary();
                return Float.valueOf(SystemLoadGaugeSet.this.loadAvg[LoadAvg.FIFTEEN_MIN.ordinal()]);
            }
        });
        return gauges;
    }

    @Override
    protected void getValueInternal() {
        String loadResult = FileUtils.readFile(this.filePath);
        Matcher loadMatcher = loadPattern.matcher(loadResult);
        if (loadMatcher.matches()) {
            this.loadAvg[LoadAvg.ONE_MIN.ordinal()] = FormatUtils.formatFloat(loadMatcher.group(1));
            this.loadAvg[LoadAvg.FIVE_MIN.ordinal()] = FormatUtils.formatFloat(loadMatcher.group(2));
            this.loadAvg[LoadAvg.FIFTEEN_MIN.ordinal()] = FormatUtils.formatFloat(loadMatcher.group(3));
        }
    }

    private static enum LoadAvg {
        ONE_MIN,
        FIVE_MIN,
        FIFTEEN_MIN;

    }
}

