/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.RandomAccessFileBackend;
import com.alibaba.csp.ahas.shaded.org.slf4j.Logger;
import com.alibaba.csp.ahas.shaded.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import sun.nio.ch.DirectBuffer;

public class ChannelFileBackend
extends RandomAccessFileBackend {
    private static final Logger logger = LoggerFactory.getLogger(ChannelFileBackend.class);
    private static final int BUFFER_SIZE = 8192;
    private static Method invokeCleaner;
    private static Object theUnsafeObject;
    private FileChannel channel;
    private ByteBuffer byteBuffer;

    public ChannelFileBackend(String path, boolean readOnly) throws IOException {
        super(path, readOnly);
        this.channel = this.randomAccessFile.getChannel();
        this.byteBuffer = ByteBuffer.allocateDirect(8192);
    }

    @Override
    public synchronized void read(long offset, byte[] b) throws IOException {
        if (b == null) {
            return;
        }
        this.byteBuffer.clear();
        int bIndex = 0;
        int remaining = b.length;
        int bytesRead = this.channel.read(this.byteBuffer, offset);
        while (bytesRead != -1) {
            int length = 0;
            length = remaining > bytesRead ? bytesRead : remaining;
            this.byteBuffer.flip();
            this.byteBuffer.get(b, bIndex, length);
            bIndex += length;
            this.byteBuffer.clear();
            offset += (long)length;
            if ((remaining -= bytesRead) <= 0) break;
            bytesRead = this.channel.read(this.byteBuffer, offset);
        }
    }

    @Override
    public synchronized void write(long offset, byte[] b, int bytesStart, int length) throws IOException {
        if (b == null) {
            return;
        }
        if (length > b.length - bytesStart) {
            length = b.length - bytesStart;
        }
        int bufferRemaining = this.byteBuffer.remaining();
        int bytesRemaining = length;
        while (bytesRemaining > 0) {
            if (bufferRemaining < bytesRemaining) {
                this.byteBuffer.put(b, bytesStart, bufferRemaining);
            } else {
                this.byteBuffer.put(b, bytesStart, bytesRemaining);
            }
            this.byteBuffer.flip();
            int writeBytes = this.channel.write(this.byteBuffer, offset);
            bytesRemaining -= writeBytes;
            this.byteBuffer.clear();
            bufferRemaining = this.byteBuffer.remaining();
            bytesStart += writeBytes;
            offset += (long)writeBytes;
        }
    }

    @Override
    public synchronized void write(long offset, ByteBuffer b) throws IOException {
    }

    @Override
    public synchronized void read(long offset, ByteBuffer b) throws IOException {
    }

    @Override
    public synchronized void sync() throws IOException {
        this.channel.force(false);
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
        this.clean();
    }

    private void clean() {
        if (!this.byteBuffer.isDirect()) {
            return;
        }
        if (invokeCleaner != null && theUnsafeObject != null) {
            try {
                invokeCleaner.invoke(theUnsafeObject, this.byteBuffer);
            }
            catch (Throwable e) {
                logger.error("Error during clean direct byte buffer: ", e);
            }
        } else {
            ((DirectBuffer)((Object)this.byteBuffer)).cleaner().clean();
        }
    }

    static {
        try {
            Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
            invokeCleaner = unsafeClass.getMethod("invokeCleaner", ByteBuffer.class);
            Field theUnsafe = unsafeClass.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            theUnsafeObject = theUnsafe.get(null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

