/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricLevel;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.AbstractFileBackend;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.ChannelFileBackend;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.utils.FileUtil;
import com.alibaba.csp.ahas.shaded.org.slf4j.Logger;
import com.alibaba.csp.ahas.shaded.org.slf4j.LoggerFactory;
import java.io.File;
import java.io.IOException;

public class LogFile {
    private static final Logger logger = LoggerFactory.getLogger(LogFile.class);
    private static final long DEFAULT_DATA_EXPAND_SIZE = 0x200000L;
    private AbstractFileBackend backend;
    private MetricLevel level;
    private String path;

    public LogFile(String path, MetricLevel level) {
        this.path = path;
        this.level = level;
    }

    public void init() throws IOException {
        this.backend = new ChannelFileBackend(this.path, false);
    }

    public void create() throws IOException {
        File logFile = new File(this.path);
        logFile.createNewFile();
        this.init();
    }

    public void write(long metricsTime, byte[] dataBlock) throws IOException {
        long position = this.backend.getLength();
        if (FileUtil.checkFileSize(position + (long)dataBlock.length)) {
            this.backend.write(position, dataBlock, 0, dataBlock.length);
        } else {
            logger.error("Exceeded file size {}, path: {}", (Object)0x40000000L, (Object)this.path);
        }
    }

    public void flush() throws IOException {
    }

    public String getPath() {
        return this.path;
    }

    public MetricLevel getLevel() {
        return this.level;
    }

    public long getPosition() {
        return this.backend.getLength();
    }

    public void close() throws IOException {
        this.backend.sync();
        this.backend.close();
    }
}

