/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Clock;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.ClusterHistogram;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Compass;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Counter;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.FastCompass;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Gauge;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Histogram;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.IMetricManager;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Meter;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Metric;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricFilter;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricLevel;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricName;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Timer;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.common.ClassifiedMetricsCollector;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.common.CollectLevel;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.common.MetricObject;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.common.MetricsCollector;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.common.MetricsCollectorFactory;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.common.config.MetricsCollectPeriodConfig;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.common.filter.BucketMetricLevelFilter;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.MetricManagerReporter;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.BinAppender;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.file.FileAppender;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.file.JsonMetricFormat;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.file.MetricFormat;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.status.LogDescriptionManager;
import com.alibaba.csp.ahas.shaded.org.slf4j.Logger;
import com.alibaba.csp.ahas.shaded.org.slf4j.LoggerFactory;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class StructMetricManagerReporter
extends MetricManagerReporter {
    private static final Logger logger = LoggerFactory.getLogger(StructMetricManagerReporter.class);
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final byte[] DEFAULT_DELIMITER_BYTES = "\n".getBytes(UTF_8);
    private static final String appName = System.getProperty("project.name", "DEFAULT_APP");
    static final String INIT_FLAG = "com.alibaba.csp.ahas.shaded.com.alibaba.metrics.struct_reporter.init_flag";
    private final Clock clock;
    private final Map<String, String> globalTags;
    private final MetricFilter filter;
    private final BinAppender binAppender;
    private final FileAppender fileAppender;
    private final MetricsCollectPeriodConfig metricsReportPeriodConfig;
    private final MetricFormat metricFormat;
    private LogDescriptionManager logDescriptionManager;
    private volatile boolean advancedMetricsReport = false;
    private volatile boolean writeMetricToFile = false;
    private Map<MetricLevel, Long> lastTimestamp = new HashMap<MetricLevel, Long>();
    private CollectLevel collectLevel;

    public StructMetricManagerReporter(IMetricManager metricManager, BinAppender binAppender, FileAppender fileAppender, LogDescriptionManager logDescriptionManager) {
        this(metricManager, binAppender, fileAppender, Clock.defaultClock(), TimeUnit.SECONDS, TimeUnit.SECONDS, TimeUnit.SECONDS, MetricFilter.ALL, new MetricsCollectPeriodConfig(), new HashMap<String, String>(), new JsonMetricFormat(), CollectLevel.CLASSIFIER);
        this.logDescriptionManager = logDescriptionManager;
    }

    public StructMetricManagerReporter(IMetricManager metricManager, BinAppender binAppender, FileAppender fileAppender, Clock clock, TimeUnit rateUnit, TimeUnit timestampPrecision, TimeUnit durationUnit, MetricFilter filter, MetricsCollectPeriodConfig metricsReportPeriodConfig, Map<String, String> globalTags, MetricFormat metricFormat, CollectLevel collectLevel) {
        super(metricManager, "bin-reporter", filter, new BucketMetricLevelFilter(metricsReportPeriodConfig), rateUnit, durationUnit);
        this.binAppender = binAppender;
        this.fileAppender = fileAppender;
        this.metricFormat = metricFormat;
        this.clock = clock;
        this.globalTags = globalTags;
        this.collectLevel = collectLevel;
        this.metricsReportPeriodConfig = metricsReportPeriodConfig;
        this.filter = filter;
        this.logDescriptionManager = new LogDescriptionManager(this.binAppender.getPath());
        this.fillLastUpdateTime();
    }

    @Override
    public void start(long period, TimeUnit unit) {
        String initFlag = System.getProperty(INIT_FLAG);
        if ("false".equals(initFlag)) {
            logger.info("StructMetricManagerReporter disabled...");
            return;
        }
        if (initFlag == null) {
            System.setProperty(INIT_FLAG, "true");
            super.start(period, unit);
        } else {
            logger.info("StructMetricManagerReporter has been started...");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void report(Map<MetricName, Gauge> gauges, Map<MetricName, Counter> counters, Map<MetricName, Histogram> histograms, Map<MetricName, Meter> meters, Map<MetricName, Timer> timers, Map<MetricName, Compass> compasses, Map<MetricName, FastCompass> fastCompasses, Map<MetricName, ClusterHistogram> clusterHistogrames) {
        long timestamp = this.clock.getTime();
        MetricsCollector collector = MetricsCollectorFactory.createNew(this.collectLevel, this.globalTags, this.rateFactor, this.durationFactor);
        ((ClassifiedMetricsCollector)collector).setLastTimestamp(this.lastTimestamp);
        ((ClassifiedMetricsCollector)collector).setAdvancedMetricsReport(this.advancedMetricsReport);
        logger.debug("last report timestamp is : CRITICAL : {}; MAJOR : {}; NORMAL : {}; MINOR : {}; TRIVIAL : {}", this.lastTimestamp.get((Object)MetricLevel.CRITICAL), this.lastTimestamp.get((Object)MetricLevel.MAJOR), this.lastTimestamp.get((Object)MetricLevel.NORMAL), this.lastTimestamp.get((Object)MetricLevel.MINOR), this.lastTimestamp.get((Object)MetricLevel.TRIVIAL));
        for (Map.Entry<MetricName, Gauge> entry : gauges.entrySet()) {
            if (entry.getValue().getValue() instanceof Collection && ((Collection)entry.getValue().getValue()).isEmpty()) continue;
            collector.collect(entry.getKey(), entry.getValue(), timestamp);
        }
        for (Map.Entry<MetricName, Metric> entry : counters.entrySet()) {
            collector.collect(entry.getKey(), (Counter)entry.getValue(), timestamp);
        }
        for (Map.Entry<MetricName, Metric> entry : histograms.entrySet()) {
            collector.collect(entry.getKey(), (Histogram)entry.getValue(), timestamp);
        }
        for (Map.Entry<MetricName, Metric> entry : meters.entrySet()) {
            collector.collect(entry.getKey(), (Meter)entry.getValue(), timestamp);
        }
        for (Map.Entry<MetricName, Metric> entry : timers.entrySet()) {
            collector.collect(entry.getKey(), (Timer)entry.getValue(), timestamp);
        }
        for (Map.Entry<MetricName, Metric> entry : compasses.entrySet()) {
            collector.collect(entry.getKey(), (Compass)entry.getValue(), timestamp);
        }
        for (Map.Entry<MetricName, Metric> entry : fastCompasses.entrySet()) {
            collector.collect(entry.getKey(), (FastCompass)entry.getValue(), timestamp);
        }
        for (Map.Entry<MetricName, Metric> entry : clusterHistogrames.entrySet()) {
            collector.collect(entry.getKey(), (ClusterHistogram)entry.getValue(), timestamp);
        }
        Map<MetricLevel, Map<Long, List<MetricObject>>> metrics = ((ClassifiedMetricsCollector)collector).getMetrics();
        if (metrics.size() <= 0) {
            return;
        }
        Iterator<Map.Entry<MetricLevel, Map<Long, List<MetricObject>>>> iterator = metrics.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<MetricLevel, Map<Long, List<MetricObject>>> entry = iterator.next();
            final MetricLevel level = entry.getKey();
            int interval = this.metricsReportPeriodConfig.period(level) * 1000;
            long startTime = this.lastTimestamp.get((Object)level) + (long)interval;
            long endTime = (timestamp / (long)interval - 1L) * (long)interval;
            startTime = ((ClassifiedMetricsCollector)collector).adjustStartTime(startTime, endTime, interval, level);
            Map<Long, List<MetricObject>> timeSequenced = metrics.get((Object)level);
            logger.debug("MetricLevel : {}, startTime : {}, endTime : {}, metricsLength : {}", new Object[]{level, startTime, endTime, timeSequenced == null ? "null" : Integer.valueOf(timeSequenced.size())});
            try {
                for (long time = startTime; time <= endTime; time += (long)interval) {
                    List<MetricObject> objects;
                    if (timeSequenced == null || timeSequenced.size() <= 0 || (objects = timeSequenced.get(time)) == null || objects.size() <= 0) continue;
                    this.binAppender.append(time, (Map<MetricLevel, List<MetricObject>>)new HashMap<MetricLevel, List<MetricObject>>(){
                        {
                            this.put(level, objects);
                        }
                    }, this.lastTimestamp);
                    if (this.writeMetricToFile) {
                        this.writeMetricObjectToFile(objects);
                    }
                    timeSequenced.remove(time);
                }
            }
            catch (Throwable e) {
                logger.error("write metrics data error!", e);
            }
            finally {
                this.logDescriptionManager.setLastCollectionTime(level, endTime);
                this.lastTimestamp.put(level, endTime);
            }
            iterator.remove();
        }
    }

    public void writeMetricObjectToFile(List<MetricObject> metricObjects) {
        if (null == this.fileAppender) {
            return;
        }
        try {
            for (MetricObject metric : metricObjects) {
                MetricObject copied = MetricObject.named(metric.getMetric()).withInterval(this.metricsReportPeriodConfig.period(metric.getMetricLevel())).withLevel(metric.getMetricLevel()).withTags(this.merge(metric.getTags(), "appName", appName)).withMeterName(metric.getMeterName()).withTimestamp(metric.getTimestamp()).withType(metric.getMetricType()).withValue(metric.getValue()).build();
                this.fileAppender.append(this.metricFormat.formatToBytes(copied));
                this.fileAppender.append(DEFAULT_DELIMITER_BYTES);
            }
            this.fileAppender.flush();
        }
        catch (Throwable e) {
            logger.error("write metrics data error!", e);
        }
    }

    private void fillLastUpdateTime() {
        long timestamp = System.currentTimeMillis();
        for (MetricLevel level : MetricLevel.values()) {
            int interval = this.metricsReportPeriodConfig.period(level) * 1000;
            this.lastTimestamp.put(level, (timestamp / (long)interval - 1L) * (long)interval);
        }
    }

    private Map<String, String> merge(Map<String, String> tags, String extraKey, String extraValue) {
        HashMap<String, String> result = new HashMap<String, String>(tags);
        result.put(extraKey, extraValue);
        return result;
    }

    public void setAdvancedMetricsReport(boolean advancedMetricsReport) {
        this.advancedMetricsReport = advancedMetricsReport;
    }

    public void setWriteMetricToFile(boolean writeMetricToFile) {
        this.writeMetricToFile = writeMetricToFile;
    }
}

