/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.io;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.filters.IntFilter;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.filters.IntFilterFactory;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.io.IntBlockedInputStream;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.io.IntBufferOutputStream;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.io.IntOutputStream;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.packers.IntBitPacking;
import java.nio.BufferUnderflowException;
import java.nio.IntBuffer;

public class IntDecompressStream
extends IntBlockedInputStream {
    private final IntBuffer source;
    private final IntFilter filter;
    private final IntBitPacking packer;
    private final int chunkSize;
    private int availableLen = 0;

    public IntDecompressStream(IntBuffer source, IntFilterFactory factory, IntBitPacking packer) {
        super(packer.getBlockSize());
        this.source = source;
        int outLen = this.source.remaining();
        if (outLen == 0) {
            this.filter = factory.newFilter(0);
        } else {
            this.availableLen = this.source.get() - 1;
            int first = this.source.get();
            this.updateBlock(new int[]{first});
            this.filter = factory.newFilter(first);
        }
        this.packer = packer;
        this.chunkSize = this.packer.getBlockSize();
    }

    @Override
    public void fetchBlock(IntOutputStream dst) {
        int remain = this.source.remaining();
        if (this.availableLen >= this.chunkSize) {
            try {
                this.packer.decompress(this.source, dst, this.filter, 1);
                this.availableLen -= this.chunkSize;
            }
            catch (BufferUnderflowException bufferUnderflowException) {}
        } else if (this.availableLen > 0) {
            int[] last = new int[this.chunkSize];
            IntBuffer buf = IntBuffer.wrap(last);
            try {
                this.packer.decompress(this.source, new IntBufferOutputStream(buf), this.filter, 1);
                dst.write(last, 0, this.availableLen);
                this.availableLen = 0;
            }
            catch (BufferUnderflowException bufferUnderflowException) {
                // empty catch block
            }
        }
    }
}

