/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.file;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Clock;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.ClusterHistogram;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Compass;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Counter;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.FastCompass;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Gauge;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Histogram;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.IMetricManager;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Meter;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Metric;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricFilter;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricName;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Timer;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.common.CollectLevel;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.common.MetricObject;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.common.MetricsCollector;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.common.MetricsCollectorFactory;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.common.config.MetricsCollectPeriodConfig;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.MetricManagerReporter;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.file.FileAppender;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.file.MetricFormat;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.file.SimpleTextMetricFormat;
import com.alibaba.csp.ahas.shaded.org.slf4j.Logger;
import com.alibaba.csp.ahas.shaded.org.slf4j.LoggerFactory;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class FileMetricManagerReporter
extends MetricManagerReporter {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final byte[] DEFAULT_DELIMITER_BYTES = "\n".getBytes(UTF_8);
    private static final String INIT_FLAG = "com.alibaba.csp.ahas.shaded.com.alibaba.metrics.file_reporter.init_flag";
    private final Logger logger = LoggerFactory.getLogger(FileMetricManagerReporter.class);
    private final Clock clock;
    private final Map<String, String> globalTags;
    private final TimeUnit timestampPrecision;
    private final MetricFormat metricFormat;
    private final FileAppender fileAppender;
    private CollectLevel collectLevel;

    private FileMetricManagerReporter(IMetricManager metricManager, FileAppender fileAppender, Clock clock, TimeUnit rateUnit, TimeUnit timestampPrecision, TimeUnit durationUnit, MetricFilter filter, MetricsCollectPeriodConfig metricsReportPeriodConfig, Map<String, String> globalTags, MetricFormat metricFormat, CollectLevel collectLevel) {
        super(metricManager, "file-reporter", filter, metricsReportPeriodConfig, rateUnit, durationUnit);
        this.clock = clock;
        this.globalTags = globalTags;
        this.timestampPrecision = timestampPrecision;
        this.fileAppender = fileAppender;
        this.metricFormat = metricFormat;
        this.collectLevel = collectLevel;
    }

    public static Builder forMetricManager(IMetricManager metricManager) {
        return new Builder(metricManager);
    }

    @Override
    public void start(long period, TimeUnit unit) {
        String initFlag = System.getProperty(INIT_FLAG);
        if ("false".equals(initFlag)) {
            this.logger.info("FileMetricManagerReporter disabled...");
            return;
        }
        if (initFlag == null) {
            System.setProperty(INIT_FLAG, "true");
            super.start(period, unit);
        } else {
            this.logger.info("FileMetricManagerReporter has been started...");
        }
    }

    @Override
    public void report(Map<MetricName, Gauge> gauges, Map<MetricName, Counter> counters, Map<MetricName, Histogram> histograms, Map<MetricName, Meter> meters, Map<MetricName, Timer> timers, Map<MetricName, Compass> compasses, Map<MetricName, FastCompass> fastCompasses, Map<MetricName, ClusterHistogram> clusterHistogrames) {
        long timestamp = this.clock.getTime();
        if (TimeUnit.MICROSECONDS.equals((Object)this.timestampPrecision)) {
            timestamp /= 1000L;
        }
        MetricsCollector collector = MetricsCollectorFactory.createNew(this.collectLevel, this.globalTags, this.rateFactor, this.durationFactor);
        for (Map.Entry<MetricName, Gauge> entry : gauges.entrySet()) {
            if (entry.getValue().getValue() instanceof Collection && ((Collection)entry.getValue().getValue()).isEmpty()) continue;
            collector.collect(entry.getKey(), entry.getValue(), timestamp);
        }
        this.writeMetricObject(collector.build());
        collector.clear();
        for (Map.Entry<MetricName, Metric> entry : counters.entrySet()) {
            collector.collect(entry.getKey(), (Counter)entry.getValue(), timestamp);
        }
        this.writeMetricObject(collector.build());
        collector.clear();
        for (Map.Entry<MetricName, Metric> entry : histograms.entrySet()) {
            collector.collect(entry.getKey(), (Histogram)entry.getValue(), timestamp);
        }
        this.writeMetricObject(collector.build());
        collector.clear();
        for (Map.Entry<MetricName, Metric> entry : meters.entrySet()) {
            collector.collect(entry.getKey(), (Meter)entry.getValue(), timestamp);
        }
        this.writeMetricObject(collector.build());
        collector.clear();
        for (Map.Entry<MetricName, Metric> entry : timers.entrySet()) {
            collector.collect(entry.getKey(), (Timer)entry.getValue(), timestamp);
        }
        this.writeMetricObject(collector.build());
        collector.clear();
        for (Map.Entry<MetricName, Metric> entry : compasses.entrySet()) {
            collector.collect(entry.getKey(), (Compass)entry.getValue(), timestamp);
        }
        this.writeMetricObject(collector.build());
        collector.clear();
        for (Map.Entry<MetricName, Metric> entry : fastCompasses.entrySet()) {
            collector.collect(entry.getKey(), (FastCompass)entry.getValue(), timestamp);
        }
        this.writeMetricObject(collector.build());
        collector.clear();
    }

    public void writeMetricObject(List<MetricObject> metricObjects) {
        try {
            for (MetricObject metric : metricObjects) {
                this.fileAppender.append(this.metricFormat.formatToBytes(metric));
                this.fileAppender.append(DEFAULT_DELIMITER_BYTES);
            }
            this.fileAppender.flush();
        }
        catch (Throwable e) {
            this.logger.error("write metrics data error!", e);
        }
    }

    public void setCollectLevel(CollectLevel collectLevel) {
        this.collectLevel = collectLevel;
    }

    public static class Builder {
        private final IMetricManager metricManager;
        private Clock clock;
        private String prefix;
        private TimeUnit rateUnit;
        private TimeUnit durationUnit;
        private MetricFilter filter;
        private MetricsCollectPeriodConfig metricsReportPeriodConfig;
        private Map<String, String> globalTags;
        private MetricFormat metricFormat;
        private FileAppender fileAppender;
        private CollectLevel collectLevel;
        private TimeUnit timestampPrecision = TimeUnit.SECONDS;

        private Builder(IMetricManager metricManager) {
            this.metricManager = metricManager;
            this.clock = Clock.defaultClock();
            this.prefix = null;
            this.rateUnit = TimeUnit.SECONDS;
            this.durationUnit = TimeUnit.MILLISECONDS;
            this.filter = MetricFilter.ALL;
            this.metricFormat = new SimpleTextMetricFormat();
            this.collectLevel = CollectLevel.COMPACT;
        }

        public Builder withClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder prefixedWith(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder convertRatesTo(TimeUnit rateUnit) {
            this.rateUnit = rateUnit;
            return this;
        }

        public Builder convertDurationsTo(TimeUnit durationUnit) {
            this.durationUnit = durationUnit;
            return this;
        }

        public Builder filter(MetricFilter filter) {
            this.filter = filter;
            return this;
        }

        public Builder metricsReportPeriodConfig(MetricsCollectPeriodConfig metricsReportPeriodConfig) {
            this.metricsReportPeriodConfig = metricsReportPeriodConfig;
            return this;
        }

        public Builder withGlobalTags(Map<String, String> globalTags) {
            this.globalTags = globalTags;
            return this;
        }

        public Builder withCollectLevel(CollectLevel level) {
            this.collectLevel = this.collectLevel;
            return this;
        }

        public Builder metricFormat(MetricFormat metricFormat) {
            this.metricFormat = metricFormat;
            return this;
        }

        public Builder timestampPrecision(TimeUnit timestampPrecision) {
            if (TimeUnit.SECONDS.equals((Object)timestampPrecision) || TimeUnit.MILLISECONDS.equals((Object)timestampPrecision)) {
                this.timestampPrecision = timestampPrecision;
                return this;
            }
            throw new IllegalArgumentException("timestampPrecision must be TimeUnit.SECONDS or TimeUnit.MILLISECONDS!, do not support: " + (Object)((Object)timestampPrecision));
        }

        public Builder fileAppender(FileAppender fileAppender) {
            this.fileAppender = fileAppender;
            return this;
        }

        public FileMetricManagerReporter build() {
            if (this.globalTags == null) {
                this.globalTags = Collections.emptyMap();
            }
            return new FileMetricManagerReporter(this.metricManager, this.fileAppender, this.clock, this.rateUnit, this.timestampPrecision, this.durationUnit, this.filter, this.metricsReportPeriodConfig, this.globalTags, this.metricFormat, this.collectLevel);
        }
    }
}

