/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.file;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.file.BufferedOutputStream;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.file.FileAppender;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.file.IOUtils;
import com.alibaba.csp.ahas.shaded.org.slf4j.Logger;
import com.alibaba.csp.ahas.shaded.org.slf4j.LoggerFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.charset.Charset;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class RollingFileAppender
implements FileAppender {
    private static final Logger logger = LoggerFactory.getLogger(RollingFileAppender.class);
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    public static final int DEFAULT_MAX_FILE_SIZE = 0x3200000;
    public static final int DEFAULT_MAX_INDEX = 3;
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    public static final String DELETEFILESUFFIX = ".deleted";
    int bufferSize = 4096;
    int fileSize = 0x3200000;
    int maxIndex = 3;
    volatile long writtenSizeAfterLastSetFile = 0L;
    volatile long fileLengthWhenLastSetFile = 0L;
    static ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("RollingFileAppender"));
    volatile boolean bNeedRolling = false;
    String path;
    BufferedOutputStream bufferedOutputStream;

    public static Builder builder() {
        return new Builder();
    }

    private RollingFileAppender(String path, int maxIndex, int fileSize) {
        this.path = path;
        this.maxIndex = maxIndex;
        this.fileSize = fileSize;
        this.setFile();
        executor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    RollingFileAppender.this.checkAndMarkRolling();
                    RollingFileAppender.this.deleteNeedDeleteFile();
                }
                catch (Throwable e) {
                    logger.error("RollingFileAppender schedule task error.", e);
                }
            }
        }, 1L, 1L, TimeUnit.SECONDS);
    }

    @Override
    public void append(String message) {
        byte[] bytes = message.getBytes(UTF_8);
        this.append(bytes);
    }

    @Override
    public void append(byte[] data) {
        try {
            this.bufferedOutputStream.write(data);
            this.writtenSizeAfterLastSetFile += (long)data.length;
            this.rollOver();
        }
        catch (Throwable e) {
            logger.error("append error, path:" + this.path, e);
            this.setFile();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.bufferedOutputStream != null) {
            this.bufferedOutputStream.flush();
            File file = new File(this.path);
            if (file.exists() && file.length() - this.fileLengthWhenLastSetFile != this.writtenSizeAfterLastSetFile) {
                this.bNeedRolling = true;
            }
        }
    }

    void checkAndMarkRolling() {
        long fileLength;
        if (this.writtenSizeAfterLastSetFile >= (long)this.fileSize) {
            this.bNeedRolling = true;
            return;
        }
        File file = new File(this.path);
        this.bNeedRolling = file.exists() ? ((fileLength = file.length()) >= (long)this.fileSize ? true : fileLength - this.fileLengthWhenLastSetFile > this.writtenSizeAfterLastSetFile) : true;
    }

    void deleteNeedDeleteFile() {
        File[] listFiles;
        File logFile = new File(this.path);
        File parent = logFile.getParentFile();
        if (parent != null && parent.isDirectory() && (listFiles = parent.listFiles()) != null) {
            for (File file : listFiles) {
                if (!file.isFile() || !file.getName().startsWith(logFile.getName()) || !file.getName().endsWith(DELETEFILESUFFIX)) continue;
                file.delete();
            }
        }
    }

    private void setFile() {
        File parentFile;
        this.writtenSizeAfterLastSetFile = 0L;
        File file = new File(this.path);
        if (!file.exists() && (parentFile = file.getParentFile()) != null) {
            parentFile.mkdirs();
        }
        if (this.bufferedOutputStream != null) {
            IOUtils.closeQuietly(this.bufferedOutputStream);
        }
        try {
            this.fileLengthWhenLastSetFile = file.length();
            this.bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file, true), this.bufferSize);
        }
        catch (FileNotFoundException e) {
            logger.error("can not open file:" + this.path, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollOver() {
        if (this.bNeedRolling) {
            File logFile;
            FileLock fileLock;
            RandomAccessFile raf;
            File lockFile;
            block12: {
                block11: {
                    String lockFilePath = this.path + ".lock";
                    lockFile = new File(lockFilePath);
                    raf = null;
                    fileLock = null;
                    try {
                        raf = new RandomAccessFile(lockFile, "rw");
                    }
                    catch (FileNotFoundException e) {
                        IOUtils.closeQuietly(fileLock);
                        IOUtils.closeQuietly(raf);
                        this.setFile();
                        return;
                    }
                    fileLock = raf.getChannel().tryLock();
                    if (fileLock != null) break block11;
                    IOUtils.closeQuietly(fileLock);
                    IOUtils.closeQuietly(raf);
                    this.setFile();
                    return;
                }
                logFile = new File(this.path);
                long logFileLength = logFile.length();
                if (logFileLength == 0L) {
                    this.setFile();
                }
                if (logFileLength >= (long)this.fileSize) break block12;
                IOUtils.closeQuietly(fileLock);
                IOUtils.closeQuietly(raf);
                this.setFile();
                return;
            }
            try {
                this.rollIndexFile();
                File index1File = this.indexFile(1);
                this.closeFile();
                logFile.renameTo(index1File);
            }
            catch (IOException e) {
                try {
                    logger.error("try to roll log file error. file:" + lockFile.getAbsolutePath(), e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fileLock);
                    IOUtils.closeQuietly(raf);
                    this.setFile();
                    throw throwable;
                }
                IOUtils.closeQuietly(fileLock);
                IOUtils.closeQuietly(raf);
                this.setFile();
            }
            IOUtils.closeQuietly(fileLock);
            IOUtils.closeQuietly(raf);
            this.setFile();
        }
    }

    private void rollIndexFile() {
        File maxIndexFile;
        File indexFile;
        int currentMaxIndex = 0;
        for (int i = 1; i <= this.maxIndex; ++i) {
            indexFile = this.indexFile(i);
            if (indexFile.exists() && i != this.maxIndex) continue;
            currentMaxIndex = i;
            break;
        }
        if (currentMaxIndex == this.maxIndex && (maxIndexFile = this.indexFile(this.maxIndex)).exists() && !maxIndexFile.renameTo(new File(maxIndexFile.getAbsolutePath() + DELETEFILESUFFIX)) && !maxIndexFile.delete()) {
            logger.error("can not delete file:" + maxIndexFile.getAbsolutePath());
        }
        for (int index = currentMaxIndex - 1; index > 0; --index) {
            File destFile;
            indexFile = this.indexFile(index);
            if (!indexFile.exists() || indexFile.renameTo(destFile = this.indexFile(index + 1))) continue;
            logger.error("can not rename file. src:" + indexFile.getAbsolutePath() + ", dest:" + destFile.getAbsolutePath());
            if (indexFile.delete()) continue;
            logger.error("can not delete file:" + indexFile.getAbsolutePath());
        }
    }

    private void closeFile() {
        if (this.bufferedOutputStream != null) {
            try {
                this.bufferedOutputStream.close();
            }
            catch (Exception e) {
                logger.error("can not close file:" + this.path, e);
            }
            this.bufferedOutputStream = null;
        }
    }

    private File indexFile(int index) {
        return new File(this.path + "." + index);
    }

    public static class Builder {
        String baseDir;
        String name;
        int maxIndex = 3;
        int fileSize = 0x3200000;

        public Builder baseDir(String baseDir) {
            this.baseDir = baseDir;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder maxIndex(int maxIndex) {
            this.maxIndex = maxIndex;
            return this;
        }

        public Builder fileSize(int fileSize) {
            this.fileSize = fileSize;
            return this;
        }

        public RollingFileAppender build() {
            if (this.baseDir == null) {
                this.baseDir = System.getProperty("user.home", "/tmp");
                if (this.baseDir != null) {
                    this.baseDir = new File(this.baseDir, "logs").getAbsolutePath();
                }
            }
            return new RollingFileAppender(new File(this.baseDir, this.name).getAbsolutePath(), this.maxIndex, this.fileSize);
        }
    }

    private static class NamedThreadFactory
    implements ThreadFactory {
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        private NamedThreadFactory(String name) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "metrics-" + name + "-thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            t.setDaemon(true);
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

