/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.opentsdb;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.opentsdb.OpenTsdbMetric;
import com.alibaba.csp.ahas.shaded.org.slf4j.Logger;
import com.alibaba.csp.ahas.shaded.org.slf4j.LoggerFactory;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import org.glassfish.jersey.jackson.JacksonFeature;

public class OpenTsdb {
    public static final int DEFAULT_BATCH_SIZE_LIMIT = 0;
    public static final int CONN_TIMEOUT_DEFAULT_MS = 5000;
    public static final int READ_TIMEOUT_DEFAULT_MS = 5000;
    private static final Logger logger = LoggerFactory.getLogger(OpenTsdb.class);
    private final WebTarget apiResource;
    private int batchSizeLimit = 0;

    public static Builder forService(String baseUrl) {
        return new Builder(baseUrl);
    }

    public static OpenTsdb create(WebTarget apiResource) {
        return new OpenTsdb(apiResource);
    }

    private OpenTsdb(WebTarget apiResource) {
        this.apiResource = apiResource;
    }

    private OpenTsdb(String baseURL, Integer connectionTimeout, Integer readTimeout) {
        Client client = ((ClientBuilder)ClientBuilder.newBuilder().register(JacksonFeature.class)).build();
        client.property("jersey.config.client.connectTimeout", connectionTimeout);
        client.property("jersey.config.client.readTimeout", readTimeout);
        this.apiResource = client.target(baseURL);
    }

    public void setBatchSizeLimit(int batchSizeLimit) {
        this.batchSizeLimit = batchSizeLimit;
    }

    public void send(OpenTsdbMetric metric) {
        this.send(Collections.singleton(metric));
    }

    public void send(Set<OpenTsdbMetric> metrics) {
        if (this.batchSizeLimit > 0 && metrics.size() > this.batchSizeLimit) {
            HashSet<OpenTsdbMetric> smallMetrics = new HashSet<OpenTsdbMetric>();
            for (OpenTsdbMetric metric : metrics) {
                smallMetrics.add(metric);
                if (smallMetrics.size() < this.batchSizeLimit) continue;
                this.sendHelper(smallMetrics);
                smallMetrics.clear();
            }
            this.sendHelper(smallMetrics);
        } else {
            this.sendHelper(metrics);
        }
    }

    private void sendHelper(Set<OpenTsdbMetric> metrics) {
        if (!metrics.isEmpty()) {
            try {
                Entity<Set<OpenTsdbMetric>> entity = Entity.entity(metrics, "application/json");
                this.apiResource.path("/api/put").request().post(entity);
            }
            catch (Exception ex) {
                logger.error("send to opentsdb endpoint failed", ex);
            }
        }
    }

    public static class Builder {
        private Integer connectionTimeout = 5000;
        private Integer readTimeout = 5000;
        private final String baseUrl;

        public Builder(String baseUrl) {
            this.baseUrl = baseUrl;
        }

        public Builder withConnectTimeout(Integer connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public Builder withReadTimeout(Integer readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public OpenTsdb create() {
            return new OpenTsdb(this.baseUrl, this.connectionTimeout, this.readTimeout);
        }
    }
}

