/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.opentsdb;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class OpenTsdbMetric {
    private String metric;
    private Long timestamp;
    private Object value;
    private Map<String, String> tags = new HashMap<String, String>();

    private OpenTsdbMetric() {
    }

    public static Builder named(String name) {
        return new Builder(name);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpenTsdbMetric)) {
            return false;
        }
        OpenTsdbMetric rhs = (OpenTsdbMetric)o;
        return this.equals(this.metric, rhs.metric) && this.equals(this.timestamp, rhs.timestamp) && this.equals(this.value, rhs.value) && this.equals(this.tags, rhs.tags);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.metric, this.timestamp, this.value, this.tags});
    }

    public String toString() {
        return this.getClass().getSimpleName() + "->metric: " + this.metric + ",value: " + this.value + ",timestamp: " + this.timestamp + ",tags: " + this.tags;
    }

    public String getMetric() {
        return this.metric;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public Object getValue() {
        return this.value;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    private boolean equals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static class Builder {
        private final OpenTsdbMetric metric = new OpenTsdbMetric();

        public Builder(String name) {
            this.metric.metric = name;
        }

        public OpenTsdbMetric build() {
            return this.metric;
        }

        public Builder withValue(Object value) {
            this.metric.value = value;
            return this;
        }

        public Builder withTimestamp(Long timestamp) {
            this.metric.timestamp = timestamp;
            return this;
        }

        public Builder withTags(Map<String, String> tags) {
            if (tags != null) {
                this.metric.tags.putAll(tags);
            }
            return this;
        }
    }
}

