/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.opentsdb;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Clock;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Counter;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Gauge;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Histogram;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Meter;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Metric;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricFilter;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricName;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricRegistry;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Snapshot;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Timer;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.ScheduledReporter;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.opentsdb.OpenTsdb;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.opentsdb.OpenTsdbMetric;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;

public class OpenTsdbReporter
extends ScheduledReporter {
    private final OpenTsdb opentsdb;
    private final Clock clock;
    private final String prefix;
    private final Map<String, String> globalTags;
    private final TimeUnit timestampPrecision;

    public static Builder forRegistry(MetricRegistry registry) {
        return new Builder(registry);
    }

    private OpenTsdbReporter(MetricRegistry registry, OpenTsdb opentsdb, Clock clock, String prefix, TimeUnit rateUnit, TimeUnit durationUnit, TimeUnit timestampPrecision, MetricFilter filter, Map<String, String> globalTags) {
        super(registry, "opentsdb-reporter", filter, rateUnit, durationUnit);
        this.opentsdb = opentsdb;
        this.clock = clock;
        this.prefix = prefix;
        this.globalTags = globalTags;
        this.timestampPrecision = timestampPrecision;
    }

    @Override
    public void report(SortedMap<MetricName, Gauge> gauges, SortedMap<MetricName, Counter> counters, SortedMap<MetricName, Histogram> histograms, SortedMap<MetricName, Meter> meters, SortedMap<MetricName, Timer> timers) {
        long timestamp = this.clock.getTime();
        if (TimeUnit.MICROSECONDS.equals((Object)this.timestampPrecision)) {
            timestamp /= 1000L;
        }
        HashSet<OpenTsdbMetric> metrics = new HashSet<OpenTsdbMetric>();
        for (Map.Entry<MetricName, Gauge> entry : gauges.entrySet()) {
            if (entry.getValue().getValue() instanceof Collection && ((Collection)entry.getValue().getValue()).isEmpty()) continue;
            metrics.add(this.buildGauge(entry.getKey(), entry.getValue(), timestamp));
        }
        for (Map.Entry<MetricName, Metric> entry : counters.entrySet()) {
            metrics.add(this.buildCounter(entry.getKey(), (Counter)entry.getValue(), timestamp));
        }
        for (Map.Entry<MetricName, Metric> entry : histograms.entrySet()) {
            metrics.addAll(this.buildHistograms(entry.getKey(), (Histogram)entry.getValue(), timestamp));
        }
        for (Map.Entry<MetricName, Metric> entry : meters.entrySet()) {
            metrics.addAll(this.buildMeters(entry.getKey(), (Meter)entry.getValue(), timestamp));
        }
        for (Map.Entry<MetricName, Metric> entry : timers.entrySet()) {
            metrics.addAll(this.buildTimers(entry.getKey(), (Timer)entry.getValue(), timestamp));
        }
        this.opentsdb.send(metrics);
    }

    private Set<OpenTsdbMetric> buildTimers(MetricName name, Timer timer, long timestamp) {
        MetricsCollector collector = MetricsCollector.createNew(this.prefix(name.getKey()), this.merge(this.globalTags, name.getTags()), timestamp);
        Snapshot snapshot = timer.getSnapshot();
        return collector.addMetric("count", timer.getCount()).addMetric("m15", this.convertRate(timer.getFifteenMinuteRate())).addMetric("m5", this.convertRate(timer.getFiveMinuteRate())).addMetric("m1", this.convertRate(timer.getOneMinuteRate())).addMetric("mean_rate", this.convertRate(timer.getMeanRate())).addMetric("max", this.convertDuration(snapshot.getMax())).addMetric("min", this.convertDuration(snapshot.getMin())).addMetric("mean", this.convertDuration(snapshot.getMean())).addMetric("stddev", this.convertDuration(snapshot.getStdDev())).addMetric("median", this.convertDuration(snapshot.getMedian())).addMetric("p75", this.convertDuration(snapshot.get75thPercentile())).addMetric("p95", this.convertDuration(snapshot.get95thPercentile())).addMetric("p98", this.convertDuration(snapshot.get98thPercentile())).addMetric("p99", this.convertDuration(snapshot.get99thPercentile())).addMetric("p999", this.convertDuration(snapshot.get999thPercentile())).build();
    }

    private Set<OpenTsdbMetric> buildHistograms(MetricName name, Histogram histogram, long timestamp) {
        MetricsCollector collector = MetricsCollector.createNew(this.prefix(name.getKey()), this.merge(this.globalTags, name.getTags()), timestamp);
        Snapshot snapshot = histogram.getSnapshot();
        return collector.addMetric("count", histogram.getCount()).addMetric("max", snapshot.getMax()).addMetric("min", snapshot.getMin()).addMetric("mean", snapshot.getMean()).addMetric("stddev", snapshot.getStdDev()).addMetric("median", snapshot.getMedian()).addMetric("p75", snapshot.get75thPercentile()).addMetric("p95", snapshot.get95thPercentile()).addMetric("p98", snapshot.get98thPercentile()).addMetric("p99", snapshot.get99thPercentile()).addMetric("p999", snapshot.get999thPercentile()).build();
    }

    private Set<OpenTsdbMetric> buildMeters(MetricName name, Meter meter, long timestamp) {
        MetricsCollector collector = MetricsCollector.createNew(this.prefix(name.getKey()), this.merge(this.globalTags, name.getTags()), timestamp);
        return collector.addMetric("count", meter.getCount()).addMetric("mean_rate", this.convertRate(meter.getMeanRate())).addMetric("m1", this.convertRate(meter.getOneMinuteRate())).addMetric("m5", this.convertRate(meter.getFiveMinuteRate())).addMetric("m15", this.convertRate(meter.getFifteenMinuteRate())).build();
    }

    private OpenTsdbMetric buildCounter(MetricName name, Counter counter, long timestamp) {
        return OpenTsdbMetric.named(this.prefix(name.getKey(), "count")).withTimestamp(timestamp).withValue(counter.getCount()).withTags(this.merge(this.globalTags, name.getTags())).build();
    }

    private OpenTsdbMetric buildGauge(MetricName name, Gauge gauge, long timestamp) {
        return OpenTsdbMetric.named(this.prefix(name.getKey(), "value")).withValue(gauge.getValue()).withTimestamp(timestamp).withTags(this.merge(this.globalTags, name.getTags())).build();
    }

    private String prefix(String ... components) {
        return MetricRegistry.name(this.prefix, components).getKey();
    }

    private Map<String, String> merge(Map<String, String> map1, Map<String, String> map2) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.putAll(map1);
        result.putAll(map2);
        return result;
    }

    private static class MetricsCollector {
        private final String prefix;
        private final Map<String, String> tags;
        private final long timestamp;
        private final Set<OpenTsdbMetric> metrics = new HashSet<OpenTsdbMetric>();

        private MetricsCollector(String prefix, Map<String, String> tags, long timestamp) {
            this.prefix = prefix;
            this.tags = tags;
            this.timestamp = timestamp;
        }

        public static MetricsCollector createNew(String prefix, Map<String, String> tags, long timestamp) {
            return new MetricsCollector(prefix, tags, timestamp);
        }

        public MetricsCollector addMetric(String metricName, Object value) {
            this.metrics.add(OpenTsdbMetric.named(MetricRegistry.name(this.prefix, metricName).getKey()).withTimestamp(this.timestamp).withValue(value).withTags(this.tags).build());
            return this;
        }

        public Set<OpenTsdbMetric> build() {
            return this.metrics;
        }
    }

    public static class Builder {
        private final MetricRegistry registry;
        private Clock clock;
        private String prefix;
        private TimeUnit rateUnit;
        private TimeUnit durationUnit;
        private MetricFilter filter;
        private Map<String, String> globalTags;
        private int batchSize;
        private TimeUnit timestampPrecision = TimeUnit.SECONDS;

        private Builder(MetricRegistry registry) {
            this.registry = registry;
            this.clock = Clock.defaultClock();
            this.prefix = null;
            this.rateUnit = TimeUnit.SECONDS;
            this.durationUnit = TimeUnit.MILLISECONDS;
            this.filter = MetricFilter.ALL;
            this.batchSize = 0;
        }

        public Builder withClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder prefixedWith(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder convertRatesTo(TimeUnit rateUnit) {
            this.rateUnit = rateUnit;
            return this;
        }

        public Builder convertDurationsTo(TimeUnit durationUnit) {
            this.durationUnit = durationUnit;
            return this;
        }

        public Builder filter(MetricFilter filter) {
            this.filter = filter;
            return this;
        }

        public Builder withGlobalTags(Map<String, String> globalTags) {
            this.globalTags = globalTags;
            return this;
        }

        public Builder withBatchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Builder timestampPrecision(TimeUnit timestampPrecision) {
            if (TimeUnit.SECONDS.equals((Object)timestampPrecision) || TimeUnit.MILLISECONDS.equals((Object)timestampPrecision)) {
                this.timestampPrecision = timestampPrecision;
                return this;
            }
            throw new IllegalArgumentException("timestampPrecision must be TimeUnit.SECONDS or TimeUnit.MILLISECONDS!, do not support: " + (Object)((Object)timestampPrecision));
        }

        public OpenTsdbReporter build(OpenTsdb opentsdb) {
            opentsdb.setBatchSizeLimit(this.batchSize);
            if (this.globalTags == null) {
                this.globalTags = Collections.emptyMap();
            }
            return new OpenTsdbReporter(this.registry, opentsdb, this.clock, this.prefix, this.rateUnit, this.timestampPrecision, this.durationUnit, this.filter, this.globalTags);
        }
    }
}

