/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.tomcat;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.CachedMetricSet;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Clock;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Metric;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricName;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.PersistentGauge;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.tomcat.JMXUtils;
import com.alibaba.csp.ahas.shaded.org.slf4j.Logger;
import com.alibaba.csp.ahas.shaded.org.slf4j.LoggerFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class ThreadGaugeSet
extends CachedMetricSet {
    private static final Logger logger = LoggerFactory.getLogger(ThreadGaugeSet.class);
    private static final String[] metricNames = new String[]{"busy_count", "total_count", "min_pool_size", "max_pool_size", "thread_pool_queue_size"};
    private int[] threadMetrics = new int[ThreadMetrics.values().length];
    private MBeanServer mbeanServer;
    private ObjectName threadPool = JMXUtils.createObjectName("*:type=ThreadPool,*");

    public ThreadGaugeSet() {
        this(DEFAULT_DATA_TTL, TimeUnit.MILLISECONDS, Clock.defaultClock());
    }

    public ThreadGaugeSet(long dataTTL, TimeUnit unit) {
        this(dataTTL, unit, Clock.defaultClock());
    }

    public ThreadGaugeSet(long dataTTL, TimeUnit unit, Clock clock) {
        super(dataTTL, unit, clock);
        this.mbeanServer = JMXUtils.getMBeanServer();
    }

    @Override
    protected void getValueInternal() {
        ObjectName[] connectorNames;
        for (ObjectName connectorName : connectorNames = JMXUtils.getObjectNames(this.threadPool)) {
            String name = ObjectName.unquote(connectorName.getKeyProperty("name"));
            try {
                this.threadMetrics[ThreadMetrics.BUSY_COUNT.ordinal()] = (Integer)this.mbeanServer.getAttribute(connectorName, "currentThreadsBusy");
                this.threadMetrics[ThreadMetrics.TOTAL_COUNT.ordinal()] = (Integer)this.mbeanServer.getAttribute(connectorName, "currentThreadCount");
                this.threadMetrics[ThreadMetrics.MIN_POOL_SIZE.ordinal()] = (Integer)this.mbeanServer.getAttribute(connectorName, "minSpareThreads");
                this.threadMetrics[ThreadMetrics.MAX_POOL_SIZE.ordinal()] = (Integer)this.mbeanServer.getAttribute(connectorName, "maxThreads");
                break;
            }
            catch (Exception e) {
                logger.error("Exception occur when getting connector global stats: ", e);
                try {
                    this.threadMetrics[ThreadMetrics.THREAD_POOL_QUEUE_SIZE.ordinal()] = (Integer)this.mbeanServer.getAttribute(connectorName, "threadPoolTaskQueueSize");
                }
                catch (Exception e2) {
                    logger.error("Exception occur when getting connector global stats: ", e2);
                }
            }
        }
    }

    @Override
    public Map<MetricName, Metric> getMetrics() {
        HashMap<MetricName, Metric> gauges = new HashMap<MetricName, Metric>();
        for (ThreadMetrics metric : ThreadMetrics.values()) {
            gauges.put(MetricName.build(metricNames[metric.ordinal()]), new ThreadStatGauge(metric.ordinal()));
        }
        return gauges;
    }

    private class ThreadStatGauge
    extends PersistentGauge<Integer> {
        private int index;

        public ThreadStatGauge(int index) {
            this.index = index;
        }

        @Override
        public Integer getValue() {
            ThreadGaugeSet.this.refreshIfNecessary();
            return ThreadGaugeSet.this.threadMetrics[this.index];
        }
    }

    private static enum ThreadMetrics {
        BUSY_COUNT,
        TOTAL_COUNT,
        MIN_POOL_SIZE,
        MAX_POOL_SIZE,
        THREAD_POOL_QUEUE_SIZE;

    }
}

