/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FigureUtil {
    public static long getLong(byte b0, byte b1, byte b2, byte b3, byte b4, byte b5, byte b6, byte b7) {
        int high = FigureUtil.getInt(b0, b1, b2, b3);
        int low = FigureUtil.getInt(b4, b5, b6, b7);
        return ((long)high << 32) + ((long)low & 0xFFFFFFFFL);
    }

    public static int getInt(byte b0, byte b1, byte b2, byte b3) {
        return (b0 << 24 & 0xFF000000) + (b1 << 16 & 0xFF0000) + (b2 << 8 & 0xFF00) + (b3 << 0 & 0xFF);
    }

    public static long getLong(byte[] b, int start) {
        int high = FigureUtil.getInt(b, start);
        int low = FigureUtil.getInt(b, start + 4);
        return ((long)high << 32) + ((long)low & 0xFFFFFFFFL);
    }

    public static int getInt(byte[] b, int start) {
        return (b[start] << 24 & 0xFF000000) + (b[start + 1] << 16 & 0xFF0000) + (b[start + 2] << 8 & 0xFF00) + (b[start + 3] << 0 & 0xFF);
    }

    public static String getString(byte[] b, int start, int length) {
        return new String(b, start, length);
    }

    public static double getDouble(byte[] b, int start) {
        return Double.longBitsToDouble(FigureUtil.getLong(b, start));
    }

    public static boolean mapIsEmpty(Map<?, ?> map) {
        if (map == null) {
            return true;
        }
        return map.size() == 0;
    }

    public static int getValueLength(Object o) {
        if (o instanceof Integer) {
            return 4;
        }
        if (o instanceof Long) {
            return 8;
        }
        if (o instanceof Double) {
            return 8;
        }
        if (o instanceof Float) {
            return 4;
        }
        return 8;
    }

    public static int getValueType(Object o) {
        if (o instanceof Integer) {
            return 0;
        }
        if (o instanceof Long) {
            return 1;
        }
        if (o instanceof Double) {
            return 2;
        }
        if (o instanceof Float) {
            return 3;
        }
        return 1;
    }

    public static Object getValueByType(int fieldType, long value) {
        Number o = null;
        switch (fieldType) {
            case 0: {
                o = (int)value;
                break;
            }
            case 2: {
                o = FigureUtil.longToDouble(value);
                break;
            }
            case 1: {
                o = value;
                break;
            }
            case 3: {
                o = Float.valueOf(FigureUtil.longToFloat(value));
                break;
            }
            default: {
                o = value;
            }
        }
        return o;
    }

    public static long convertToLong(Object o) {
        long value = 0L;
        if (o instanceof Long) {
            value = (Long)o;
        }
        if (o instanceof Integer) {
            value = ((Integer)o).longValue();
        }
        if (o instanceof Double) {
            value = FigureUtil.doubleRoundToLong((Double)o);
        }
        if (o instanceof Float) {
            value = FigureUtil.floatRoundToLong(((Float)o).floatValue());
        }
        return value;
    }

    public static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(String str) {
        return !FigureUtil.isBlank(str);
    }

    public static long getTodayStartTimestamp(long timestamp) {
        return (timestamp + 28800000L) / 86400000L * 86400000L - 28800000L;
    }

    public static long getNextDayStartTimestamp(long timestamp) {
        return ((timestamp + 28800000L) / 86400000L + 1L) * 86400000L - 28800000L;
    }

    public static byte[] getLongBytes(long value) {
        byte[] b = new byte[]{(byte)((int)(value >>> 56) & 0xFF), (byte)((int)(value >>> 48) & 0xFF), (byte)((int)(value >>> 40) & 0xFF), (byte)((int)(value >>> 32) & 0xFF), (byte)((int)(value >>> 24) & 0xFF), (byte)((int)(value >>> 16) & 0xFF), (byte)((int)(value >>> 8) & 0xFF), (byte)((int)(value >>> 0) & 0xFF)};
        return b;
    }

    public static List<Long> splitRangeByDay(long startTime, long endTime) {
        long baseEndTime;
        ArrayList<Long> result = new ArrayList<Long>();
        if (startTime > endTime) {
            return result;
        }
        long baseStartTime = FigureUtil.getNextDayStartTimestamp(startTime);
        if (baseStartTime > (baseEndTime = FigureUtil.getTodayStartTimestamp(endTime))) {
            result.add(startTime);
            result.add(endTime);
        } else {
            int crossingDay = (int)((baseEndTime - baseStartTime) / 86400000L);
            result.add(startTime);
            for (int i = 0; i <= crossingDay; ++i) {
                result.add(baseStartTime + (long)(i * 86400000) - 1000L);
                result.add(baseStartTime + (long)(i * 86400000));
            }
            result.add(endTime);
        }
        return result;
    }

    public static long doubleRoundToLong(double d) {
        return Math.round(d * 10000.0);
    }

    public static long floatRoundToLong(float f) {
        return Math.round(f * 10000.0f);
    }

    public static double longToDouble(long l) {
        return (double)l / 10000.0;
    }

    public static float longToFloat(long l) {
        return (float)l / 10000.0f;
    }

    public static boolean checkZero(Object o) {
        if (o instanceof Long && (Long)o == 0L) {
            return true;
        }
        if (o instanceof Integer && (Integer)o == 0) {
            return true;
        }
        if (o instanceof Double && (Double)o == 0.0) {
            return true;
        }
        return o instanceof Float && ((Float)o).floatValue() == 0.0f;
    }

    public static void main(String[] args) {
        System.out.println(FigureUtil.floatRoundToLong(97.99f));
    }
}

