/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.fasterxml.jackson.databind.deser.std;

import com.alibaba.csp.ahas.shaded.com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.csp.ahas.shaded.com.fasterxml.jackson.core.JsonParser;
import com.alibaba.csp.ahas.shaded.com.fasterxml.jackson.core.JsonToken;
import com.alibaba.csp.ahas.shaded.com.fasterxml.jackson.databind.BeanProperty;
import com.alibaba.csp.ahas.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import com.alibaba.csp.ahas.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import com.alibaba.csp.ahas.shaded.com.fasterxml.jackson.databind.JavaType;
import com.alibaba.csp.ahas.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import com.alibaba.csp.ahas.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import com.alibaba.csp.ahas.shaded.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.alibaba.csp.ahas.shaded.com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.alibaba.csp.ahas.shaded.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.alibaba.csp.ahas.shaded.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.alibaba.csp.ahas.shaded.com.fasterxml.jackson.databind.util.ObjectBuffer;
import java.io.IOException;

@JacksonStdImpl
public final class StringArrayDeserializer
extends StdDeserializer<String[]>
implements ContextualDeserializer {
    private static final long serialVersionUID = 2L;
    public static final StringArrayDeserializer instance = new StringArrayDeserializer();
    protected JsonDeserializer<String> _elementDeserializer;
    protected final Boolean _unwrapSingle;

    public StringArrayDeserializer() {
        this(null, null);
    }

    protected StringArrayDeserializer(JsonDeserializer<?> deser, Boolean unwrapSingle) {
        super(String[].class);
        this._elementDeserializer = deser;
        this._unwrapSingle = unwrapSingle;
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        JsonDeserializer<Object> deser = this._elementDeserializer;
        deser = this.findConvertingContentDeserializer(ctxt, property, deser);
        JavaType type = ctxt.constructType(String.class);
        deser = deser == null ? ctxt.findContextualValueDeserializer(type, property) : ctxt.handleSecondaryContextualization(deser, property, type);
        Boolean unwrapSingle = this.findFormatFeature(ctxt, property, String[].class, JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        if (deser != null && this.isDefaultDeserializer(deser)) {
            deser = null;
        }
        if (this._elementDeserializer == deser && this._unwrapSingle == unwrapSingle) {
            return this;
        }
        return new StringArrayDeserializer(deser, unwrapSingle);
    }

    @Override
    public String[] deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (!p.isExpectedStartArrayToken()) {
            return this.handleNonArray(p, ctxt);
        }
        if (this._elementDeserializer != null) {
            return this._deserializeCustom(p, ctxt);
        }
        ObjectBuffer buffer = ctxt.leaseObjectBuffer();
        Object[] chunk = buffer.resetAndStart();
        int ix = 0;
        try {
            while (true) {
                String value;
                if ((value = p.nextTextValue()) == null) {
                    JsonToken t = p.getCurrentToken();
                    if (t == JsonToken.END_ARRAY) break;
                    if (t != JsonToken.VALUE_NULL) {
                        value = this._parseString(p, ctxt);
                    }
                }
                if (ix >= chunk.length) {
                    chunk = buffer.appendCompletedChunk(chunk);
                    ix = 0;
                }
                chunk[ix++] = value;
            }
        }
        catch (Exception e) {
            throw JsonMappingException.wrapWithPath((Throwable)e, (Object)chunk, buffer.bufferedSize() + ix);
        }
        String[] result = buffer.completeAndClearBuffer(chunk, ix, String.class);
        ctxt.returnObjectBuffer(buffer);
        return result;
    }

    protected final String[] _deserializeCustom(JsonParser p, DeserializationContext ctxt) throws IOException {
        ObjectBuffer buffer = ctxt.leaseObjectBuffer();
        Object[] chunk = buffer.resetAndStart();
        JsonDeserializer<String> deser = this._elementDeserializer;
        int ix = 0;
        try {
            while (true) {
                String value;
                if (p.nextTextValue() == null) {
                    JsonToken t = p.getCurrentToken();
                    if (t == JsonToken.END_ARRAY) break;
                    value = t == JsonToken.VALUE_NULL ? deser.getNullValue(ctxt) : deser.deserialize(p, ctxt);
                } else {
                    value = deser.deserialize(p, ctxt);
                }
                if (ix >= chunk.length) {
                    chunk = buffer.appendCompletedChunk(chunk);
                    ix = 0;
                }
                chunk[ix++] = value;
            }
        }
        catch (Exception e) {
            throw JsonMappingException.wrapWithPath((Throwable)e, String.class, ix);
        }
        String[] result = buffer.completeAndClearBuffer(chunk, ix, String.class);
        ctxt.returnObjectBuffer(buffer);
        return result;
    }

    @Override
    public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        return typeDeserializer.deserializeTypedFromArray(p, ctxt);
    }

    private final String[] handleNonArray(JsonParser p, DeserializationContext ctxt) throws IOException {
        String str;
        boolean canWrap;
        boolean bl = canWrap = this._unwrapSingle == Boolean.TRUE || this._unwrapSingle == null && ctxt.isEnabled(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        if (canWrap) {
            return new String[]{p.hasToken(JsonToken.VALUE_NULL) ? null : this._parseString(p, ctxt)};
        }
        if (p.hasToken(JsonToken.VALUE_STRING) && ctxt.isEnabled(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT) && (str = p.getText()).length() == 0) {
            return null;
        }
        return (String[])ctxt.handleUnexpectedToken(this._valueClass, p);
    }
}

