/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.client.bootstrap.outer;

import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.client.api.bootstrap.BaseAgwClient;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.client.api.bootstrap.ClientToServerRpcMetadata;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.client.api.bootstrap.ResponseCallback;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.client.api.exception.AgwRpcException;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.client.bootstrap.outer.ClientToServerAgwConfig;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.connection.client.ClientConnection;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.connection.client.ClientConnectionPool;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.io.client.ClientConfig;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.io.protocol.AgwMessage;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.io.protocol.AgwMessageFactory;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.io.protocol.AgwMessageHeader;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.io.protocol.ReqBizMessageBuilder;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.log.AgwLogger;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.log.AgwPerfLogger;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.oss.OssCert;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.upstream.RpcResultCodeEnum;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.utils.AgwStringUtil;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.utils.misc.IpUtil;

public final class AgwClient
extends BaseAgwClient<ClientToServerAgwConfig, ClientToServerRpcMetadata, ResponseCallback> {
    private static AgwClient client = new AgwClient();
    private String clientVpcId;
    private String clientIp;
    private String clientProcessFlag;
    private long clientIpLong;

    private AgwClient() {
    }

    public static AgwClient getInstance() {
        return client;
    }

    @Override
    protected boolean init0(ClientToServerAgwConfig config) {
        String clientVpcId = config.getClientVpcId();
        String clientIp = config.getClientIp();
        String clientProcessFlag = config.getClientProcessFlag();
        if (AgwStringUtil.isBlank(clientVpcId)) {
            throw new AgwRpcException(RpcResultCodeEnum.RPC_CLIENT_VPCID_EMPTY_EXCEPTION);
        }
        if (AgwStringUtil.isBlank(clientIp)) {
            throw new AgwRpcException(RpcResultCodeEnum.RPC_CLIENT_IP_FORMAT_WRONG);
        }
        if (AgwStringUtil.isBlank(clientProcessFlag)) {
            throw new AgwRpcException(RpcResultCodeEnum.RPC_CLIENT_PROCESS_FLAG_EMPTY_EXCEPTION);
        }
        this.clientVpcId = clientVpcId;
        this.clientIp = clientIp;
        this.clientProcessFlag = clientProcessFlag;
        this.clientIpLong = IpUtil.ipToLong(clientIp);
        ClientConfig.init(config.getAhasGatewayIp(), config.getAhasGatewayPort(), config.isTls(), config.getRegionId(), config.getEnv());
        if (ClientConfig.TLS) {
            OssCert.createOrUpdateClientCert(ClientConfig.REGION_ID, ClientConfig.ENV);
        }
        return true;
    }

    @Override
    protected String call0(String reqId, ClientToServerRpcMetadata rpcMetadata, String jsonParam) {
        if (rpcMetadata == null) {
            AgwLogger.warn(String.format("RPC_RPC_METADATA_NULL_EXCEPTION, reqId:%d, outerReqId:%s", 12315L, reqId), new Object[0]);
            throw new AgwRpcException(RpcResultCodeEnum.RPC_RPC_METADATA_NULL_EXCEPTION);
        }
        rpcMetadata.check();
        if (AgwStringUtil.isBlank(jsonParam)) {
            AgwLogger.warn(String.format("RPC_REQUEST_BODY_NULL_EXCEPTION, reqId:%d, outerReqId:%s", 12315L, reqId), new Object[0]);
            throw new AgwRpcException(RpcResultCodeEnum.RPC_REQUEST_BODY_NULL_EXCEPTION);
        }
        ClientConnection connection = ClientConnectionPool.getInstance().getConnection(ClientConfig.TLS);
        if (connection == null) {
            if (ClientConfig.TLS) {
                OssCert.createOrUpdateClientCert(ClientConfig.REGION_ID, ClientConfig.ENV);
                connection = ClientConnectionPool.getInstance().getConnection(ClientConfig.TLS);
                if (connection == null) {
                    AgwLogger.warn(String.format("RPC_USER_CONNECTION_LOST, reqId:%d, outerReqId:%s", 12315L, reqId), new Object[0]);
                    throw new AgwRpcException(RpcResultCodeEnum.RPC_USER_CONNECTION_LOST);
                }
            }
            AgwLogger.warn(String.format("RPC_USER_CONNECTION_LOST, reqId:%d, outerReqId:%s", 12315L, reqId), new Object[0]);
            throw new AgwRpcException(RpcResultCodeEnum.RPC_USER_CONNECTION_LOST);
        }
        int timeoutMs = rpcMetadata.getOptionalTimeoutMs() <= 4000 ? 4000 : rpcMetadata.getOptionalTimeoutMs();
        int connectionId = connection.getConnectionId();
        AgwMessage request = AgwMessageFactory.createAgwMessage(ReqBizMessageBuilder.getInstance(), this.clientVpcId, this.clientIpLong, this.clientProcessFlag, rpcMetadata.getServerHandlerName(), connectionId, rpcMetadata.getServerName(), timeoutMs, rpcMetadata.isRequestCompress(), rpcMetadata.isResponseCompress(), jsonParam);
        if (request == null) {
            AgwLogger.warn(String.format("RPC_BUILD_MESSAGE_WRONG, reqId:%d, outerReqId:%s", 12315L, reqId), new Object[0]);
            throw new AgwRpcException(RpcResultCodeEnum.RPC_BUILD_MESSAGE_WRONG);
        }
        request.getHeader().setOuterReqId(reqId);
        request.mark("client_call_gateway");
        request.mark("before_call");
        AgwMessage response = connection.writeAndFlushSync(request);
        request.mark("after_call");
        if (response == null) {
            AgwLogger.warn(String.format("RPC_USER_TO_GW_RESULT_EMPTY_EXCEPTION, reqId:%d, outerReqId:%s", request.getHeader().getReqId(), reqId), new Object[0]);
            request.mark("call_gateway_exception");
            AgwPerfLogger.info(request.getPerf(), new Object[0]);
            throw new AgwRpcException(RpcResultCodeEnum.RPC_USER_TO_GW_RESULT_EMPTY_EXCEPTION);
        }
        AgwMessageHeader responseHeader = response.getHeader();
        if (responseHeader.getInnerCode() != RpcResultCodeEnum.RPC_OK.getCode()) {
            AgwLogger.warn(String.format("code:%d, msg:%s, reqId:%d, outerReqId:%s", responseHeader.getInnerCode(), responseHeader.getInnerMsg(), request.getHeader().getReqId(), reqId), new Object[0]);
            request.mark("call_gateway_exception");
            AgwPerfLogger.info(request.getPerf(), new Object[0]);
            throw new AgwRpcException(responseHeader.getInnerCode(), responseHeader.getInnerMsg());
        }
        request.mark("after_call");
        AgwPerfLogger.info(request.getPerf(), new Object[0]);
        return response.getBody();
    }

    @Override
    protected String callWithCallBack0(String reqId, ClientToServerRpcMetadata rpcMetadata, String jsonParam, ResponseCallback callback) {
        throw new AgwRpcException(RpcResultCodeEnum.RPC_UNSUPPORT_OPERATION);
    }

    @Override
    protected void destroy0() {
    }

    public static AgwClient getClient() {
        return client;
    }

    public static void setClient(AgwClient client) {
        AgwClient.client = client;
    }

    public String getClientVpcId() {
        return this.clientVpcId;
    }

    public void setClientVpcId(String clientVpcId) {
        this.clientVpcId = clientVpcId;
    }

    public String getClientIp() {
        return this.clientIp;
    }

    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }

    public String getClientProcessFlag() {
        return this.clientProcessFlag;
    }

    public void setClientProcessFlag(String clientProcessFlag) {
        this.clientProcessFlag = clientProcessFlag;
    }

    public long getClientIpLong() {
        return this.clientIpLong;
    }

    public void setClientIpLong(long clientIpLong) {
        this.clientIpLong = clientIpLong;
    }

    public static void main(String[] args) {
    }
}

