/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.connection.client;

import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.connection.Connection;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.io.protocol.AgwMessage;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.io.protocol.AgwMessageHeader;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.io.protocol.util.KeyGenerator;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.log.AgwLogger;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.upstream.RpcResultCodeEnum;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.utils.thread.DefaultListenableFuture;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.utils.thread.Futures;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.utils.thread.SettableFuture;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.utils.thread.ThreadPoolManager;
import com.alibaba.csp.ahas.shaded.io.netty.channel.Channel;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ClientConnection
implements Connection {
    private Channel channel;
    private int connectionId;
    private String innerId;
    private Map<String, SettableFuture<AgwMessage>> id2Handler = new HashMap<String, SettableFuture<AgwMessage>>();

    public ClientConnection(Channel channel) {
        this.channel = channel;
        this.innerId = UUID.randomUUID().toString();
    }

    @Override
    public boolean isInited() {
        return false;
    }

    @Override
    public boolean init(AgwMessage agwMessage) {
        return true;
    }

    @Override
    public void writeAndFlush(AgwMessage msg) {
        this.channel.writeAndFlush(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AgwMessage writeAndFlushSync(AgwMessage msg) {
        DefaultListenableFuture future = Futures.createSettableFuture(ThreadPoolManager.getInstance().getClientThreadPool());
        this.id2Handler.put(KeyGenerator.generateMsgIdForConnection(msg), future);
        this.channel.writeAndFlush(msg);
        AgwMessage response = null;
        RpcResultCodeEnum exceptionResult = null;
        try {
            response = (AgwMessage)future.get(msg.getHeader().getTimeoutMs(), TimeUnit.MILLISECONDS);
            return response;
        }
        catch (InterruptedException e) {
            AgwLogger.warn(String.format("InterruptedException: %s", msg.toString()), e);
            this.handleSyncWriteError(msg);
            exceptionResult = RpcResultCodeEnum.RPC_WRITE_INTERRUPTED_EXCEPTION;
            return exceptionResult;
        }
        catch (ExecutionException e) {
            AgwLogger.warn(String.format("ExecutionException: %s", msg.toString()), e);
            this.handleSyncWriteError(msg);
            exceptionResult = RpcResultCodeEnum.RPC_WRITE_EXECUTION_EXCEPTION;
            return exceptionResult;
        }
        catch (TimeoutException e) {
            long end = System.currentTimeMillis();
            AgwLogger.warn(String.format("timeout: %s", msg.toString()), e);
            this.handleSyncWriteError(msg);
            exceptionResult = RpcResultCodeEnum.RPC_TIMEOUT;
            return exceptionResult;
        }
        finally {
            if (exceptionResult != null) {
                response = new AgwMessage();
                AgwMessageHeader header = new AgwMessageHeader();
                response.setHeader(header);
                header.setInnerCode(exceptionResult.getCode());
                header.setInnerMsg(exceptionResult.getMessage());
            }
            return response;
        }
    }

    @Override
    public void notifySyncWrite(AgwMessage msg) {
        SettableFuture<AgwMessage> future = this.id2Handler.remove(KeyGenerator.generateMsgIdForConnection(msg));
        if (future == null) {
            AgwLogger.info("future is blank", new Object[0]);
            return;
        }
        future.set(msg);
    }

    @Override
    public void handleSyncWriteError(AgwMessage msg) {
        this.id2Handler.remove(KeyGenerator.generateMsgIdForConnection(msg));
    }

    @Override
    public void close() {
        HashSet<String> removeSet = new HashSet<String>(this.id2Handler.keySet());
        for (String id : removeSet) {
            SettableFuture<AgwMessage> future;
            if (id == null || (future = this.id2Handler.remove(id)) == null) continue;
            AgwMessage msg = new AgwMessage();
            AgwMessageHeader header = new AgwMessageHeader();
            msg.setHeader(header);
            header.setInnerCode(RpcResultCodeEnum.RPC_CLIENT_CLOSE_EXCEPTION.getCode());
            header.setInnerMsg(RpcResultCodeEnum.RPC_CLIENT_CLOSE_EXCEPTION.getMessage());
            future.set(msg);
        }
        if (this.channel != null) {
            this.channel.close();
        }
    }

    @Override
    public String info() {
        return String.valueOf(this.connectionId);
    }

    @Override
    public String uuid() {
        return this.innerId;
    }

    public int getConnectionId() {
        return this.connectionId;
    }

    public void setConnectionId(int connectionId) {
        this.connectionId = connectionId;
    }
}

