/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.io.client;

import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.connection.client.ClientConnection;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.io.client.NettyClientHandler;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.io.client.codec.ProtocolHandler;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.io.protocol.util.ConnectionUtil;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.log.AgwLogger;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.oss.OssCert;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.tls.SslContextFactory;
import com.alibaba.csp.ahas.shaded.io.netty.bootstrap.Bootstrap;
import com.alibaba.csp.ahas.shaded.io.netty.buffer.PooledByteBufAllocator;
import com.alibaba.csp.ahas.shaded.io.netty.channel.ChannelFuture;
import com.alibaba.csp.ahas.shaded.io.netty.channel.ChannelHandler;
import com.alibaba.csp.ahas.shaded.io.netty.channel.ChannelInitializer;
import com.alibaba.csp.ahas.shaded.io.netty.channel.ChannelOption;
import com.alibaba.csp.ahas.shaded.io.netty.channel.nio.NioEventLoopGroup;
import com.alibaba.csp.ahas.shaded.io.netty.channel.socket.nio.NioSocketChannel;
import com.alibaba.csp.ahas.shaded.io.netty.handler.ssl.SslHandler;
import com.alibaba.csp.ahas.shaded.io.netty.handler.timeout.IdleStateHandler;
import com.alibaba.csp.ahas.shaded.io.netty.util.concurrent.DefaultThreadFactory;
import java.net.InetSocketAddress;
import javax.net.ssl.SSLEngine;

public final class NettyClient {
    private static final String CONNECT_TIMEOUT_KEY = "_CONNECTTIMEOUT";
    public static NettyClient instance = new NettyClient();
    public static final NioEventLoopGroup WORKER_POOL = new NioEventLoopGroup(0, new DefaultThreadFactory("nettyNioEventLoop", true));

    private NettyClient() {
    }

    public static NettyClient getInstance() {
        return instance;
    }

    public ClientConnection connect(String ip, int port, final Integer connectionId, final boolean tls) {
        ChannelFuture future = null;
        ClientConnection cc = null;
        try {
            Bootstrap bootstrap = new Bootstrap();
            ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group(WORKER_POOL)).option(ChannelOption.TCP_NODELAY, true)).option(ChannelOption.SO_REUSEADDR, true)).option(ChannelOption.ALLOCATOR, PooledByteBufAllocator.DEFAULT)).option(ChannelOption.AUTO_CLOSE, Boolean.TRUE)).option(ChannelOption.ALLOW_HALF_CLOSURE, Boolean.FALSE)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, 1000)).channel(NioSocketChannel.class)).handler(new ChannelInitializer<NioSocketChannel>(){

                @Override
                protected void initChannel(NioSocketChannel ch) throws Exception {
                    if (tls) {
                        SSLEngine engine = SslContextFactory.getClientContext(OssCert.clientCertPath, OssCert.clientCertPath).createSSLEngine();
                        engine.setUseClientMode(true);
                        ch.pipeline().addLast("ssl", (ChannelHandler)new SslHandler(engine));
                    }
                    ch.pipeline().addLast("protocol", (ChannelHandler)new ProtocolHandler()).addLast("clientIdleHandler", (ChannelHandler)new IdleStateHandler(0, 0, 10)).addLast("clientHandler", (ChannelHandler)new NettyClientHandler(connectionId));
                }
            });
            future = bootstrap.connect(new InetSocketAddress(ip, port));
            future.awaitUninterruptibly();
            if (future.isSuccess()) {
                if (ConnectionUtil.connectionOfChannel(future.channel()) == null) {
                    ClientConnection connection = new ClientConnection(future.channel());
                    connection.setConnectionId(connectionId);
                    ConnectionUtil.bindConnection(future.channel(), connection);
                }
                cc = (ClientConnection)ConnectionUtil.connectionOfChannel(future.channel());
            } else {
                AgwLogger.warn(String.format("connect %s:%d wrong", ip, port), future.cause());
            }
        }
        catch (Throwable e) {
            AgwLogger.warn(String.format("connect to %s:%d wrong", ip, port), e);
        }
        return cc;
    }
}

