/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.utils.thread;

import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.utils.thread.NamedThreadFactory;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ThreadPoolManager {
    private static ThreadPoolManager instance = new ThreadPoolManager();
    private ThreadPoolExecutor serverDataProcessPool;
    private ThreadPoolExecutor serverTopologyPool;
    private ThreadPoolExecutor serverTopologyHeartbeatPool;
    private ThreadPoolExecutor clientPool;
    private AtomicBoolean serverDataProcessPoolInited = new AtomicBoolean();
    private AtomicBoolean serverTopologyPoolInited = new AtomicBoolean();
    private AtomicBoolean serverTopologyHeartbeatPoolInited = new AtomicBoolean();
    private AtomicBoolean clientPoolInited = new AtomicBoolean();

    private ThreadPoolManager() {
    }

    public static ThreadPoolManager getInstance() {
        return instance;
    }

    private void initServerDataProcessThreadPool() {
        int coreSize = 100;
        int maxSize = 200;
        long keepAliveTime = 20L;
        NamedThreadFactory threadFactory = new NamedThreadFactory("AgwBizDataProcessProcessor - DEFAULT");
        this.serverDataProcessPool = new ThreadPoolExecutor(coreSize, maxSize, keepAliveTime, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(800), threadFactory);
    }

    private void initServerTopologyThreadPool() {
        int coreSize = 75;
        int maxSize = 150;
        long keepAliveTime = 20L;
        NamedThreadFactory threadFactory = new NamedThreadFactory("AgwBizTopologyProcessor - DEFAULT");
        this.serverTopologyPool = new ThreadPoolExecutor(coreSize, maxSize, keepAliveTime, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(600), threadFactory);
    }

    private void initServerTopologyHeartbeatThreadPool() {
        int coreSize = 75;
        int maxSize = 150;
        long keepAliveTime = 20L;
        NamedThreadFactory threadFactory = new NamedThreadFactory("AgwBizTopologyHeartBeatProcessor - DEFAULT");
        this.serverTopologyHeartbeatPool = new ThreadPoolExecutor(coreSize, maxSize, keepAliveTime, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(600), threadFactory);
    }

    public ThreadPoolExecutor getServerDataProcessThreadPool() {
        if (this.serverDataProcessPoolInited.get()) {
            return this.serverDataProcessPool;
        }
        if (this.serverDataProcessPoolInited.compareAndSet(false, true)) {
            this.initServerDataProcessThreadPool();
            return this.serverDataProcessPool;
        }
        try {
            TimeUnit.MILLISECONDS.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.serverDataProcessPool;
    }

    public ThreadPoolExecutor getServerTopologyThreadPool() {
        if (this.serverTopologyPoolInited.get()) {
            return this.serverTopologyPool;
        }
        if (this.serverTopologyPoolInited.compareAndSet(false, true)) {
            this.initServerTopologyThreadPool();
            return this.serverTopologyPool;
        }
        try {
            TimeUnit.MILLISECONDS.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.serverTopologyPool;
    }

    public ThreadPoolExecutor getServerTopologyHeartbeatThreadPool() {
        if (this.serverTopologyHeartbeatPoolInited.get()) {
            return this.serverTopologyHeartbeatPool;
        }
        if (this.serverTopologyHeartbeatPoolInited.compareAndSet(false, true)) {
            this.initServerTopologyHeartbeatThreadPool();
            return this.serverTopologyHeartbeatPool;
        }
        try {
            TimeUnit.MILLISECONDS.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.serverTopologyHeartbeatPool;
    }

    private void initClientThreadPool() {
        int coreSize = 2;
        int maxSize = 10;
        long keepAliveTime = 20L;
        NamedThreadFactory threadFactory = new NamedThreadFactory("AgwBizProcessor - DEFAULT");
        this.clientPool = new ThreadPoolExecutor(coreSize, maxSize, keepAliveTime, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(16), threadFactory);
    }

    public ThreadPoolExecutor getClientThreadPool() {
        if (this.clientPoolInited.get()) {
            return this.clientPool;
        }
        if (this.clientPoolInited.compareAndSet(false, true)) {
            this.initClientThreadPool();
            return this.clientPool;
        }
        try {
            TimeUnit.MILLISECONDS.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.clientPool;
    }
}

