/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.client;

import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.api.client.ClientInfoService;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.api.config.ConfigService;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.client.AppTypeParser;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.client.UrlConstants;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.config.DefaultConfigService;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.exception.AhasClientException;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.init.AhasInitFunc;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.util.AppNameUtil;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.util.VpcEcsUtil;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class DefaultClientInfoService
implements ClientInfoService,
AhasInitFunc {
    public static final String PID_DELIMITER = "@";
    public static final String DOCKER_ENV_FILE = "/.dockerenv";
    public static final int DEFAULT_GATEWAY_PORT = 9527;
    public static final String PUBLIC_REGION_ID = "cn-public";
    public static final int HOST_TYPE = 0;
    public static final int CONTAINER_TYPE = 1;
    public static final String JAVA_SDK = "JAVA_SDK";
    public static final String JAVA_AGENT = "JAVA_AGENT";
    private ConfigService configService;
    private String pid;
    private String appName;
    private String appType;
    private String ahasAppName;
    private List<String> ips;
    private String vpcId;
    private String instanceId;
    private List<String> jvmArgs;
    private String gatewayHost;
    private int gatewayPort;
    private String acmHost;
    private String cid;
    private String userId;
    private String namespace;
    private String hostname;
    private String hostIp;
    private String privateIp;
    private int deviceType = -1;
    private String tid;
    private String env;
    private String version;
    private String buildNumber;
    private String license;
    private boolean restrictedVpc;
    private boolean isPrivate;
    private String regionId;
    private Integer sentinelDisable = -1;
    private String switchVersion;
    private String type;

    public static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    @Override
    public void init(String type, ClassLoader classLoader) throws AhasClientException {
        this.configService = new DefaultConfigService().init(type, classLoader);
        this.restrictedVpc = this.configService.restrictedVpc();
        this.initPrivate();
        this.checkIdentity();
        this.initVpcId();
        this.initEndpoint();
        this.initPidAndHostname();
        this.type = type;
    }

    private void initPrivate() {
        this.isPrivate = DefaultClientInfoService.isEmpty(this.getLicense());
    }

    private void checkIdentity() throws AhasClientException {
        String license = this.getLicense();
        if (this.restrictedVpc && DefaultClientInfoService.isEmpty(license)) {
            throw new AhasClientException("License is needed in restrict vpc environment.");
        }
        if (DefaultClientInfoService.isEmpty(this.getUserId()) && DefaultClientInfoService.isEmpty(license)) {
            throw new AhasClientException("License is needed in public environment.");
        }
    }

    private void initVpcId() throws AhasClientException {
        if (this.isPrivate) {
            this.vpcId = VpcEcsUtil.getVpcId();
            return;
        }
        this.vpcId = this.getLicense();
        if (this.vpcId == null || this.vpcId.length() == 0) {
            throw new AhasClientException("cannot get vpc id");
        }
    }

    private void initEndpoint() throws AhasClientException {
        this.env = System.getProperty("ahas.env", "prod");
        if (!this.isPrivate && !this.restrictedVpc) {
            this.regionId = PUBLIC_REGION_ID;
        } else {
            this.regionId = VpcEcsUtil.getRegionId();
            if (this.regionId == null) {
                this.regionId = this.configService.getAhasRegionId();
            }
            if (this.regionId == null) {
                this.regionId = this.configService.getSAERegionId();
            }
            if (this.regionId == null) {
                throw new AhasClientException("Cannot get region-id!");
            }
        }
        String endpoint = UrlConstants.GATEWAY_MAP.get(this.env + "-" + this.regionId);
        if (DefaultClientInfoService.isBlank(endpoint)) {
            throw new AhasClientException("No AHAS proxy endpoint available, env=" + this.env + ", regionId=" + this.regionId);
        }
        this.acmHost = UrlConstants.ACM_MAP.get(this.regionId);
        if (DefaultClientInfoService.isBlank(this.acmHost)) {
            throw new AhasClientException("Cannot get ACM endpoint, regionId: " + this.regionId);
        }
        String[] split = endpoint.split(":");
        if (split.length != 2) {
            throw new AhasClientException("AHAS proxy endpoint length error");
        }
        this.gatewayHost = split[0];
        try {
            this.gatewayPort = Integer.valueOf(split[1]);
        }
        catch (NumberFormatException e) {
            this.gatewayPort = 9527;
        }
    }

    private void initPidAndHostname() {
        String processInfo = ManagementFactory.getRuntimeMXBean().getName();
        if (DefaultClientInfoService.isBlank(processInfo)) {
            return;
        }
        if (processInfo.indexOf(PID_DELIMITER) == -1) {
            return;
        }
        String[] split = processInfo.split(PID_DELIMITER);
        String processId = split[0];
        if (DefaultClientInfoService.isBlank(processId)) {
            return;
        }
        this.hostname = split[1];
        try {
            Integer.valueOf(processId);
            this.pid = processId;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private List<String> getAllIps() {
        ArrayList<String> ips = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface networkInterface = interfaces.nextElement();
                Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress inetAddress = inetAddresses.nextElement();
                    if (inetAddress.isLoopbackAddress() || inetAddress instanceof Inet6Address) continue;
                    ips.add(inetAddress.getHostAddress());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ips;
    }

    @Override
    public String getVpcId() {
        return this.vpcId;
    }

    @Override
    public String getPid() {
        if (this.pid == null) {
            this.initPidAndHostname();
        }
        return this.pid;
    }

    @Override
    public String getAppName() {
        if (this.appName != null) {
            return this.appName;
        }
        this.appName = AppNameUtil.getAppName();
        return this.appName;
    }

    @Override
    public String getAppType() {
        if (this.appType != null) {
            return this.appType;
        }
        this.appType = String.valueOf(AppTypeParser.parseAppType());
        return this.appType;
    }

    @Override
    public String getAhasAppName() {
        if (this.ahasAppName != null) {
            return this.ahasAppName;
        }
        this.ahasAppName = AppNameUtil.getAhasAppName();
        return this.ahasAppName;
    }

    @Override
    public Integer getSentinalDisable() {
        if (this.sentinelDisable != -1) {
            return this.sentinelDisable;
        }
        this.sentinelDisable = AppNameUtil.getSentinelDisable();
        return this.sentinelDisable;
    }

    @Override
    public String getHostIp() {
        if (this.hostIp != null) {
            return this.hostIp;
        }
        this.hostIp = this.isPrivate() ? VpcEcsUtil.getPrivateIpv4() : this.getPrivateIp();
        return this.hostIp;
    }

    @Override
    public boolean isRestrictedVpc() {
        return this.configService.restrictedVpc();
    }

    @Override
    public String getPrivateIp() {
        if (this.privateIp != null) {
            return this.privateIp;
        }
        if (this.isPrivate() && this.getDeviceType() == 0) {
            this.privateIp = this.getHostIp();
            return this.privateIp;
        }
        List<String> ips = this.getIps();
        if (ips != null && ips.size() > 0) {
            this.privateIp = ips.get(0);
            return this.privateIp;
        }
        return null;
    }

    @Override
    public List<String> getIps() {
        if (this.ips != null && !this.ips.isEmpty()) {
            return this.ips;
        }
        this.ips = this.getAllIps();
        return this.ips;
    }

    @Override
    public Map<String, String> getSystemProperties() {
        HashMap<String, String> map = new HashMap<String, String>(16);
        Properties properties = System.getProperties();
        for (String name : properties.stringPropertyNames()) {
            map.put(name, properties.getProperty(name));
        }
        return map;
    }

    @Override
    public List<String> getJvmArgs() {
        if (this.jvmArgs != null) {
            return this.jvmArgs;
        }
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        this.jvmArgs = runtimeMXBean.getInputArguments();
        return this.jvmArgs;
    }

    @Override
    public String getInstanceId() {
        if (this.instanceId != null) {
            return this.instanceId;
        }
        this.instanceId = this.isPrivate() ? VpcEcsUtil.getInstanceId() : this.getHostname();
        return this.instanceId;
    }

    @Override
    public String getAid() {
        return this.cid;
    }

    @Override
    public String setAid(String aid) {
        this.cid = aid;
        return this.cid;
    }

    @Override
    public String getUserId() {
        if (this.userId != null) {
            return this.userId;
        }
        this.userId = VpcEcsUtil.getUid();
        return this.userId;
    }

    @Override
    public String setUserId(String userId) {
        this.userId = userId;
        return userId;
    }

    @Override
    public String getNamespace() {
        if (this.namespace != null) {
            return this.namespace;
        }
        this.namespace = System.getProperty("ahas.namespace", "default");
        return this.namespace;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getHostname() {
        if (this.hostname == null) {
            this.initPidAndHostname();
        }
        return this.hostname;
    }

    @Override
    public int getDeviceType() {
        if (this.deviceType != -1) {
            return this.deviceType;
        }
        File file = new File(DOCKER_ENV_FILE);
        this.deviceType = file.exists() ? 1 : 0;
        return this.deviceType;
    }

    @Override
    public String getTid() {
        return this.tid;
    }

    @Override
    public void setTid(String tid) {
        this.tid = tid;
    }

    @Override
    public String getVersion() {
        if (this.version == null) {
            this.version = this.configService.getVersion();
        }
        return this.version;
    }

    @Override
    public String getBuildNumber() {
        if (this.buildNumber == null) {
            this.buildNumber = this.configService.getBuildNumber();
        }
        return this.buildNumber;
    }

    @Override
    public String getLicense() {
        if (this.license == null) {
            this.license = this.configService.getLicense();
        }
        return this.license;
    }

    @Override
    public boolean isPrivate() {
        return this.isPrivate;
    }

    @Override
    public String getAcmEndpoint() {
        return this.acmHost;
    }

    @Override
    public String getGatewayHost() {
        return this.gatewayHost;
    }

    @Override
    public int getGatewayPort() {
        return this.gatewayPort;
    }

    @Override
    public String getSwitchVersion() {
        if (this.switchVersion == null) {
            this.switchVersion = this.configService.getSwitchVersion();
        }
        return this.switchVersion;
    }

    @Override
    public String getRegionId() {
        return this.regionId;
    }

    @Override
    public String getAhasEnv() {
        return this.env;
    }
}

