/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.heartbeat;

import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.api.client.ClientInfoService;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.api.transport.TransportService;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.heartbeat.HeartbeatService;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.time.AbstractTimerService;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.transport.api.AgwRequestUri;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.transport.api.Request;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.transport.api.Response;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.transport.api.ServiceConstants;

public class SwitchHeartbeatService
extends AbstractTimerService
implements HeartbeatService {
    private TransportService transportService;
    private ClientInfoService clientInfoService;
    private HeartbeatService heartbeatService;

    public SwitchHeartbeatService() {
        super("heartbeat");
    }

    @Override
    public void init(ClientInfoService clientInfoService, TransportService transportService) {
        this.init(clientInfoService, transportService, this);
    }

    @Override
    public void init(ClientInfoService clientInfoService, TransportService transportService, HeartbeatService heartbeatService) {
        this.clientInfoService = clientInfoService;
        this.transportService = transportService;
        this.heartbeatService = heartbeatService;
        super.init();
    }

    @Override
    public Response<String> sendHeartbeat() {
        String version = this.clientInfoService.getSwitchVersion();
        try {
            Request request = new Request(true);
            request.addHeader("uid", this.clientInfoService.getUserId());
            request.addHeader("v", version);
            Response<String> response = this.transportService.invoke(new AgwRequestUri(ServiceConstants.Switch.HEARTBEAT), request, String.class);
            return response;
        }
        catch (Exception e) {
            return Response.ofFailure(Response.Code.SERVER_ERROR, e.getMessage(), null);
        }
    }

    @Override
    public void onTime() {
        this.heartbeatService.sendHeartbeat();
    }
}

