/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.transport.api;

import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.transport.api.InvalidTimestampException;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.transport.api.Request;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.transport.api.RequestException;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.transport.api.RequestInterceptorChain;

public class TimestampInterceptor
extends RequestInterceptorChain {
    public static final int MAX_INVALID_TIME = 120000;
    public static final String TIMESTAMP_KEY = "ts";

    @Override
    public void doHandle(Request request) throws RequestException {
        String ts = request.getParam(TIMESTAMP_KEY);
        if (ts == null || ts.length() == 0) {
            throw new InvalidTimestampException("missing timestamp");
        }
        try {
            long clientTime = Long.valueOf(ts);
            long serverTime = System.currentTimeMillis();
            if (serverTime - clientTime > 120000L) {
                throw new InvalidTimestampException("exceeding maximum failure time, server time: " + serverTime + ", client time: " + clientTime);
            }
        }
        catch (NumberFormatException e) {
            throw new InvalidTimestampException(ts + ", " + e.getMessage());
        }
    }

    @Override
    public void doInvoke(Request request) throws RequestException {
        request.addParam(TIMESTAMP_KEY, System.currentTimeMillis() + "");
    }
}

