/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.taobao.diamond.client.impl;

import com.alibaba.csp.ahas.shaded.com.alibaba.middleware.tls.util.TlsUtil;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.client.impl.DiamondEnv;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.client.impl.HttpSimpleClient;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.client.impl.ServerListManager;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.utils.AppNameUtils;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.utils.StringUtils;
import com.alibaba.csp.ahas.shaded.com.taobao.middleware.logger.support.LoggerHelper;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.Iterator;
import java.util.List;

public class ServerHttpAgent {
    public static final String appKey;
    public static final String appName;
    public static String domainName;
    public static String addressPort;
    final ServerListManager serverListMgr;
    volatile String currentServerIp;

    ServerHttpAgent(ServerListManager mgr) {
        this.serverListMgr = mgr;
    }

    public static void setDomainName(String domainName) {
        if (StringUtils.isNotEmpty(domainName)) {
            ServerHttpAgent.domainName = domainName;
            DiamondEnv.log.info("setDomainName", "address-server domain:{} ,address-server port:{}", domainName, addressPort);
        }
    }

    public HttpSimpleClient.HttpResult httpGet(String path, List<String> headers, List<String> paramValues, String encoding, long readTimeoutMs) throws IOException {
        long endTime = System.currentTimeMillis() + readTimeoutMs;
        String port = "8080";
        boolean isSSL = false;
        if (TlsUtil.tlsEnable()) {
            port = "443";
            isSSL = true;
        }
        if (null != this.currentServerIp) {
            try {
                port = this.serverListMgr.getPortByIp(this.currentServerIp);
                HttpSimpleClient.HttpResult result = HttpSimpleClient.httpGet(ServerHttpAgent.getUrl(this.currentServerIp, port, path, isSSL), headers, paramValues, encoding, readTimeoutMs, isSSL);
                if (result.code != 500 && result.code != 502 && result.code != 503) {
                    return result;
                }
                DiamondEnv.log.error("Diamond ConnectException", "currentServerIp:{},port:{}. httpCode:", new Object[]{this.currentServerIp, port, result.code});
            }
            catch (ConnectException ce) {
                DiamondEnv.log.error("Diamond ConnectException", "currentServerIp:{},port:{}", new Object[]{this.currentServerIp, port});
            }
            catch (SocketTimeoutException stoe) {
                DiamondEnv.log.error("Diamond  SocketTimeoutException", "currentServerIp:{},port:{}", new Object[]{this.currentServerIp, port});
            }
            catch (IOException ioe) {
                DiamondEnv.log.error("Diamond  IOException", "currentServerIp:{},port:{}", new Object[]{this.currentServerIp, port});
                throw ioe;
            }
        }
        Iterator<String> serverIter = this.serverListMgr.iterator();
        while (serverIter.hasNext()) {
            long timeout = endTime - System.currentTimeMillis();
            if (timeout <= 0L) {
                if (null != this.currentServerIp) {
                    DiamondEnv.log.error("the currentServerIp  which happened IOException in get(timeout) is: ", this.currentServerIp);
                }
                this.currentServerIp = serverIter.next();
                throw new IOException("timeout");
            }
            String ip = serverIter.next();
            try {
                port = this.serverListMgr.getPortByIp(ip);
                HttpSimpleClient.HttpResult result = HttpSimpleClient.httpGet(ServerHttpAgent.getUrl(ip, port, path, isSSL), headers, paramValues, encoding, timeout, isSSL);
                if (result.code == 500 || result.code == 502 || result.code == 503) {
                    DiamondEnv.log.error("Diamond ConnectException", "currentServerIp:{},port:{}. httpCode:", new Object[]{this.currentServerIp, port, result.code});
                    continue;
                }
                this.currentServerIp = ip;
                return result;
            }
            catch (ConnectException ce) {
                DiamondEnv.log.error("Diamond ConnectException", "currentServerIp:{},port:{}", new Object[]{this.currentServerIp, port});
            }
            catch (SocketTimeoutException stoe) {
                DiamondEnv.log.error("Diamond  SocketTimeoutException", "currentServerIp:{},port:{}", new Object[]{this.currentServerIp, port});
            }
            catch (IOException ioe) {
                DiamondEnv.log.error("Diamond  IOException", "currentServerIp:{},port:{}", new Object[]{this.currentServerIp, port});
                throw ioe;
            }
        }
        DiamondEnv.log.error("Diamond-0002", LoggerHelper.getErrorCodeStr("Diamond", "Diamond-0002", "\u73af\u5883\u95ee\u9898", "no available server"));
        throw new ConnectException("no available server");
    }

    public HttpSimpleClient.HttpResult httpPost(String path, List<String> headers, List<String> paramValues, String encoding, long readTimeoutMs) throws IOException {
        long endTime = System.currentTimeMillis() + readTimeoutMs;
        String port = "8080";
        boolean isSSL = false;
        if (TlsUtil.tlsEnable()) {
            port = "443";
            isSSL = true;
        }
        if (null != this.currentServerIp) {
            try {
                port = this.serverListMgr.getPortByIp(this.currentServerIp);
                HttpSimpleClient.HttpResult result = HttpSimpleClient.httpPost(ServerHttpAgent.getUrl(this.currentServerIp, port, path, isSSL), headers, paramValues, encoding, readTimeoutMs, isSSL);
                if (result.code != 500 && result.code != 502 && result.code != 503) {
                    return result;
                }
                DiamondEnv.log.error("Diamond ConnectException", "currentServerIp:{},port:{}. httpCode:", new Object[]{this.currentServerIp, port, result.code});
            }
            catch (ConnectException ce) {
                DiamondEnv.log.error("Diamond ConnectException", "currentServerIp:{},port:{}", new Object[]{this.currentServerIp, port});
            }
            catch (SocketTimeoutException stoe) {
                DiamondEnv.log.error("Diamond  SocketTimeoutException", "currentServerIp:{},port:{}", new Object[]{this.currentServerIp, port});
            }
            catch (IOException ioe) {
                DiamondEnv.log.error("Diamond  IOException", "currentServerIp:{},port:{}", new Object[]{this.currentServerIp, port});
                throw ioe;
            }
        }
        Iterator<String> serverIter = this.serverListMgr.iterator();
        while (serverIter.hasNext()) {
            long timeout = endTime - System.currentTimeMillis();
            if (timeout <= 0L) {
                if (null != this.currentServerIp) {
                    DiamondEnv.log.error("the currentServerIp  which happened IOException(timeout) in post is: ", this.currentServerIp);
                }
                this.currentServerIp = serverIter.next();
                throw new IOException("timeout");
            }
            String ip = serverIter.next();
            try {
                port = this.serverListMgr.getPortByIp(ip);
                HttpSimpleClient.HttpResult result = HttpSimpleClient.httpPost(ServerHttpAgent.getUrl(ip, port, path, isSSL), headers, paramValues, encoding, timeout, isSSL);
                if (result.code == 500 || result.code == 502 || result.code == 503) {
                    DiamondEnv.log.error("Diamond ConnectException", "currentServerIp:{},port:{}. httpCode:", new Object[]{this.currentServerIp, port, result.code});
                    continue;
                }
                this.currentServerIp = ip;
                return result;
            }
            catch (ConnectException ce) {
                DiamondEnv.log.error("Diamond ConnectException", "currentServerIp:{},port:{}", new Object[]{this.currentServerIp, port});
            }
            catch (SocketTimeoutException stoe) {
                DiamondEnv.log.error("Diamond  SocketTimeoutException", "currentServerIp:{},port:{}", new Object[]{this.currentServerIp, port});
            }
            catch (IOException ioe) {
                DiamondEnv.log.error("Diamond  IOException", "currentServerIp:{},port:{}", new Object[]{this.currentServerIp, port});
                throw ioe;
            }
        }
        DiamondEnv.log.error("Diamond-0002", LoggerHelper.getErrorCodeStr("Diamond", "Diamond-0002", "\u73af\u5883\u95ee\u9898", "no available server"));
        throw new ConnectException("no available server");
    }

    static String getUrl(String ip, String port, String relativePath, boolean isSSL) {
        String httpPrefix = "http://";
        if (isSSL) {
            httpPrefix = "https://";
        }
        return httpPrefix + ip + ":" + port + "/diamond-server" + relativePath;
    }

    static String getUrl(String ip, String port, String relativePath) {
        return ServerHttpAgent.getUrl(ip, port, relativePath, false);
    }

    public void reSetCurrentServerIp() {
        if (this.currentServerIp != null) {
            this.currentServerIp = null;
        }
    }

    public String getCurrentServerIp() {
        return this.currentServerIp;
    }

    public static String getAppname() {
        return appName;
    }

    static {
        String envAddressPort;
        appKey = System.getProperty("diamond.client.appKey", "");
        appName = AppNameUtils.getAppName();
        domainName = System.getenv("ahas_address_server_domain");
        if (StringUtils.isBlank(domainName) && StringUtils.isBlank(domainName = System.getProperty("ahas.address.server.domain"))) {
            domainName = System.getProperty("acm.endpoint", "jmenv.tbsite.net");
        }
        addressPort = StringUtils.isBlank(envAddressPort = System.getenv("address_server_port")) ? System.getProperty("address.server.port", "8080") : envAddressPort;
        DiamondEnv.log.info("settings", "address-server domain:{} ,address-server port:{}", domainName, addressPort);
    }
}

