/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.taobao.diamond.manager.impl;

import com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.com.google.common.collect.Lists;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.exception.DiamondException;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.manager.IConfigFilter;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.manager.IConfigFilterChain;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.manager.IConfigRequest;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.manager.IConfigResponse;
import java.util.List;

public class ConfigFilterChainManager
implements IConfigFilterChain {
    private List<IConfigFilter> filters = Lists.newArrayList();

    public synchronized ConfigFilterChainManager addFilter(IConfigFilter filter) {
        IConfigFilter currentValue;
        int i;
        for (i = 0; i < this.filters.size() && !(currentValue = this.filters.get(i)).getFilterName().equals(filter.getFilterName()); ++i) {
            if (filter.getOrder() >= currentValue.getOrder() && i < this.filters.size()) {
                continue;
            }
            this.filters.add(i, filter);
            break;
        }
        if (i == this.filters.size()) {
            this.filters.add(i, filter);
        }
        return this;
    }

    @Override
    public void doFilter(IConfigRequest request, IConfigResponse response) throws DiamondException {
        new VirtualFilterChain(this.filters).doFilter(request, response);
    }

    private static class VirtualFilterChain
    implements IConfigFilterChain {
        private final List<? extends IConfigFilter> additionalFilters;
        private int currentPosition = 0;

        public VirtualFilterChain(List<? extends IConfigFilter> additionalFilters) {
            this.additionalFilters = additionalFilters;
        }

        @Override
        public void doFilter(IConfigRequest request, IConfigResponse response) throws DiamondException {
            if (this.currentPosition == this.additionalFilters.size()) {
                return;
            }
            ++this.currentPosition;
            IConfigFilter nextFilter = this.additionalFilters.get(this.currentPosition - 1);
            nextFilter.doFilter(request, response, this);
        }
    }
}

