/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.taobao.middleware.logger.option;

import com.alibaba.csp.ahas.shaded.com.taobao.middleware.logger.Level;
import com.alibaba.csp.ahas.shaded.com.taobao.middleware.logger.Logger;
import com.alibaba.csp.ahas.shaded.com.taobao.middleware.logger.option.AbstractActiveOption;
import com.alibaba.csp.ahas.shaded.com.taobao.middleware.logger.support.LoggerHelper;
import com.alibaba.csp.ahas.shaded.org.apache.log4j.Appender;
import com.alibaba.csp.ahas.shaded.org.apache.log4j.AsyncAppender;
import com.alibaba.csp.ahas.shaded.org.apache.log4j.ConsoleAppender;
import com.alibaba.csp.ahas.shaded.org.apache.log4j.DailyRollingFileAppender;
import com.alibaba.csp.ahas.shaded.org.apache.log4j.PatternLayout;
import com.alibaba.csp.ahas.shaded.org.apache.log4j.RollingFileAppender;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class Log4jActivateOption
extends AbstractActiveOption {
    protected com.alibaba.csp.ahas.shaded.org.apache.log4j.Logger logger;

    public Log4jActivateOption(com.alibaba.csp.ahas.shaded.org.apache.log4j.Logger logger) {
        this.logger = logger;
    }

    @Override
    public void activateConsoleAppender(String target, String encoding) {
        ConsoleAppender appender = new ConsoleAppender();
        appender.setLayout(new PatternLayout(LoggerHelper.getPattern()));
        appender.setTarget(target);
        appender.setEncoding(encoding);
        appender.activateOptions();
        this.logger.removeAllAppenders();
        this.logger.addAppender(appender);
    }

    @Override
    public void activateAppender(String productName, String file, String encoding) {
        Appender appender = this.getLog4jDailyRollingFileAppender(productName, file, encoding);
        this.logger.removeAllAppenders();
        this.logger.addAppender(appender);
        this.setProductName(productName);
    }

    @Override
    public void activateAsyncAppender(String productName, String file, String encoding) {
        this.activateAsyncAppender(productName, file, encoding, Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    @Override
    public void activateAsyncAppender(String productName, String file, String encoding, int queueSize, int discardingThreshold) {
        this.activateAppender(productName, file, encoding);
        this.activateAsync(queueSize, discardingThreshold);
    }

    @Override
    public void activateAppenderWithTimeAndSizeRolling(String productName, String file, String encoding, String size) {
        this.activateAppender(productName, file, encoding);
    }

    @Override
    public void setLevel(Level level) {
        this.level = level;
        this.logger.setLevel(com.alibaba.csp.ahas.shaded.org.apache.log4j.Level.toLevel(level.getName()));
    }

    @Override
    public void setAdditivity(boolean additivity) {
        this.logger.setAdditivity(additivity);
    }

    protected Appender getLog4jDailyRollingFileAppender(String productName, String file, String encoding) {
        DailyRollingFileAppender appender = new DailyRollingFileAppender();
        appender.setName(productName + "." + file.replace(File.separatorChar, '.') + ".Appender");
        appender.setLayout(new PatternLayout(LoggerHelper.getPattern(productName)));
        appender.setAppend(true);
        appender.setFile(LoggerHelper.getLogFileP(productName, file));
        appender.setEncoding(encoding);
        appender.activateOptions();
        return appender;
    }

    @Override
    public void activateAppender(Logger logger) {
        if (!(logger.getDelegate() instanceof com.alibaba.csp.ahas.shaded.org.apache.log4j.Logger)) {
            throw new IllegalArgumentException("logger must be org.apache.log4j.Logger, but it's " + logger.getDelegate().getClass());
        }
        this.activateAppender((com.alibaba.csp.ahas.shaded.org.apache.log4j.Logger)logger.getDelegate());
        this.setProductName(logger.getProductName());
    }

    protected void activateAppender(com.alibaba.csp.ahas.shaded.org.apache.log4j.Logger logger) {
        this.logger.removeAllAppenders();
        Enumeration enums = logger.getAllAppenders();
        while (enums != null && enums.hasMoreElements()) {
            this.logger.addAppender((Appender)enums.nextElement());
        }
    }

    @Override
    public void activateAppenderWithTimeAndSizeRolling(String productName, String file, String encoding, String size, String datePattern) {
        Appender appender = this.getLog4jRollingFileAppender(productName, file, encoding, size, datePattern, -1);
        this.logger.removeAllAppenders();
        this.logger.addAppender(appender);
        this.setProductName(productName);
    }

    @Override
    public void activateAppenderWithTimeAndSizeRolling(String productName, String file, String encoding, String size, String datePattern, int maxBackupIndex) {
        Appender appender = this.getLog4jRollingFileAppender(productName, file, encoding, size, datePattern, maxBackupIndex);
        this.logger.removeAllAppenders();
        this.logger.addAppender(appender);
        this.setProductName(productName);
    }

    protected Appender getLog4jRollingFileAppender(String productName, String file, String encoding, String size, String datePattern, int maxBackupIndex) {
        RollingFileAppender appender = new RollingFileAppender();
        appender.setName(productName + "." + file.replace(File.separatorChar, '.') + ".Appender");
        appender.setLayout(new PatternLayout(LoggerHelper.getPattern(productName)));
        appender.setAppend(true);
        appender.setFile(LoggerHelper.getLogFileP(productName, file));
        appender.setEncoding(encoding);
        appender.setMaxFileSize(size);
        if (maxBackupIndex >= 0) {
            appender.setMaxBackupIndex(maxBackupIndex);
        }
        appender.activateOptions();
        return appender;
    }

    @Override
    public void activateAppenderWithSizeRolling(String productName, String file, String encoding, String size, int maxBackupIndex) {
        Appender appender = this.getLog4jRollingFileAppender(productName, file, encoding, size, null, maxBackupIndex);
        this.logger.removeAllAppenders();
        this.logger.addAppender(appender);
        this.setProductName(productName);
    }

    @Override
    public void activateAsync(int queueSize, int discardingThreshold) {
        ArrayList<Object[]> args = new ArrayList<Object[]>();
        if (queueSize != Integer.MIN_VALUE) {
            args.add(new Object[]{"setBufferSize", new Class[]{Integer.TYPE}, queueSize});
        }
        this.activateAsync(args);
    }

    @Override
    public void activateAsync(List<Object[]> args) {
        AsyncAppender asyncAppender = new AsyncAppender();
        Log4jActivateOption.invokeMethod(asyncAppender, args);
        asyncAppender.setName(this.productName + "." + this.logger.getName() + ".AsyncAppender");
        Enumeration appenders = this.logger.getAllAppenders();
        if (appenders == null) {
            throw new IllegalStateException("Activate async appender failed, no appender exist.");
        }
        while (appenders.hasMoreElements()) {
            asyncAppender.addAppender((Appender)appenders.nextElement());
        }
        appenders = this.logger.getAllAppenders();
        while (appenders.hasMoreElements()) {
            this.logger.removeAppender((Appender)appenders.nextElement());
        }
        this.logger.addAppender(asyncAppender);
        this.setProductName(this.productName);
    }
}

