/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.mybatis;

import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.SphU;
import com.alibaba.csp.sentinel.Tracer;
import com.alibaba.csp.sentinel.adapter.mybatis.MyBatisSentinelBlockException;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.util.Properties;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class SentinelMyBatisMapperInterceptor
implements Interceptor {
    public static final String MYBATIS_PREFIX = "mybatis:";
    private static final Object[] EMPTY_ARR = new Object[0];

    public Object intercept(Invocation invocation) throws Throwable {
        MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
        String mapperId = mappedStatement.getId();
        if (StringUtil.isBlank(mapperId)) {
            return invocation.proceed();
        }
        Entry entry = null;
        try {
            entry = SphU.asyncEntry(MYBATIS_PREFIX + mapperId, 4, EntryType.OUT, EMPTY_ARR);
            Object object = invocation.proceed();
            return object;
        }
        catch (BlockException ex) {
            throw new MyBatisSentinelBlockException(ex);
        }
        catch (Throwable t) {
            Tracer.traceEntry(t, entry);
            throw t;
        }
        finally {
            if (entry != null) {
                entry.exit();
            }
        }
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

