/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.mybatis;

import com.alibaba.csp.sentinel.AsyncEntry;
import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.SphU;
import com.alibaba.csp.sentinel.Tracer;
import com.alibaba.csp.sentinel.adapter.mybatis.MyBatisSentinelBlockException;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.sql.Statement;
import java.util.List;
import java.util.Properties;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;

@Intercepts(value={@Signature(method="query", type=StatementHandler.class, args={Statement.class, ResultHandler.class}), @Signature(method="update", type=StatementHandler.class, args={Statement.class})})
public class SentinelMyBatisSqlInterceptor
implements Interceptor {
    private static final Object[] EMPTY_ARR = new Object[0];

    public Object intercept(Invocation invocation) throws Throwable {
        StatementHandler stat = (StatementHandler)invocation.getTarget();
        BoundSql boundSql = stat.getBoundSql();
        String executeSql = boundSql.getSql().trim();
        if (executeSql.indexOf(10) != -1) {
            executeSql = StringUtil.replace(executeSql, "\r", "");
            executeSql = executeSql.replace('\n', ' ');
        }
        AsyncEntry entry = null;
        try {
            entry = SphU.asyncEntry(executeSql, 4, EntryType.OUT, EMPTY_ARR);
            Object object = invocation.proceed();
            return object;
        }
        catch (BlockException ex) {
            throw new MyBatisSentinelBlockException(ex);
        }
        catch (Throwable t) {
            Tracer.traceEntry(t, entry);
            throw t;
        }
        finally {
            if (entry != null) {
                entry.exit();
            }
        }
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }

    private Object[] parseParams(BoundSql boundSql) {
        Object[] params = EMPTY_ARR;
        if (boundSql.getParameterObject() instanceof MapperMethod.ParamMap) {
            MapperMethod.ParamMap paramMap = (MapperMethod.ParamMap)boundSql.getParameterObject();
            List parameterMappings = boundSql.getParameterMappings();
            int size = parameterMappings.size();
            params = new Object[size];
            for (int i = 0; i < size; ++i) {
                ParameterMapping p = (ParameterMapping)parameterMappings.get(i);
                if (p.getProperty().contains("__frch_")) continue;
                params[i] = paramMap.get((Object)p.getProperty());
            }
        }
        return params;
    }
}

