/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.sofa.rpc;

import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.SphU;
import com.alibaba.csp.sentinel.adapter.sofa.rpc.BaseSentinelFilter;
import com.alibaba.csp.sentinel.adapter.sofa.rpc.fallback.SofaRpcFallbackRegistry;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.filter.AutoActive;
import com.alipay.sofa.rpc.filter.FilterInvoker;
import com.alipay.sofa.rpc.invoke.Invoker;

@Extension(value="sentinelConsumerFilter", order=-1000)
@AutoActive(consumerSide=true)
public class SentinelSofaConsumerFilter
extends BaseSentinelFilter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SofaResponse invoke(FilterInvoker invoker, SofaRequest request) throws SofaRpcException {
        String interfaceName = request.getInterfaceName();
        String methodResourceName = "sofa:consumer:" + this.extractMethodName(request);
        Entry interfaceEntry = null;
        Entry methodEntry = null;
        try {
            interfaceEntry = SphU.entry(interfaceName, 2, EntryType.OUT);
            methodEntry = SphU.entry(methodResourceName, 2, EntryType.OUT, request.getMethodArgs());
            SofaResponse response = invoker.invoke(request);
            this.traceExceptionIfNeeded(response, methodEntry, interfaceEntry);
            SofaResponse sofaResponse = response;
            return sofaResponse;
        }
        catch (BlockException ex) {
            SofaResponse sofaResponse = SofaRpcFallbackRegistry.getConsumerFallback().handle((Invoker)invoker, request, ex);
            return sofaResponse;
        }
        finally {
            if (methodEntry != null) {
                methodEntry.exit(1, request.getMethodArgs());
            }
            if (interfaceEntry != null) {
                interfaceEntry.exit();
            }
        }
    }
}

