/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.sofa.rpc;

import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.SphU;
import com.alibaba.csp.sentinel.adapter.sofa.rpc.BaseSentinelFilter;
import com.alibaba.csp.sentinel.adapter.sofa.rpc.fallback.SofaRpcFallbackRegistry;
import com.alibaba.csp.sentinel.context.ContextUtil;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.filter.AutoActive;
import com.alipay.sofa.rpc.filter.FilterInvoker;
import com.alipay.sofa.rpc.invoke.Invoker;

@Extension(value="sentinelProviderFilter", order=-1000)
@AutoActive(providerSide=true)
public class SentinelSofaProviderFilter
extends BaseSentinelFilter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SofaResponse invoke(FilterInvoker invoker, SofaRequest request) throws SofaRpcException {
        String caller = SentinelSofaProviderFilter.getCallerAppName(request);
        String interfaceName = request.getInterfaceName();
        String methodResourceName = "sofa:provider:" + this.extractMethodName(request);
        Entry interfaceEntry = null;
        Entry methodEntry = null;
        try {
            ContextUtil.enter(methodResourceName, caller);
            interfaceEntry = SphU.entry(interfaceName, 2, EntryType.IN);
            methodEntry = SphU.entry(methodResourceName, 2, EntryType.OUT, request.getMethodArgs());
            SofaResponse response = invoker.invoke(request);
            this.traceExceptionIfNeeded(response, methodEntry, interfaceEntry);
            SofaResponse sofaResponse = response;
            return sofaResponse;
        }
        catch (BlockException ex) {
            SofaResponse sofaResponse = SofaRpcFallbackRegistry.getProviderFallback().handle((Invoker)invoker, request, ex);
            return sofaResponse;
        }
        finally {
            if (methodEntry != null) {
                methodEntry.exit(1, request.getMethodArgs());
            }
            if (interfaceEntry != null) {
                interfaceEntry.exit();
            }
            ContextUtil.exit();
        }
    }
}

