/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.annotation.aspectj;

import com.alibaba.csp.sentinel.Tracer;
import com.alibaba.csp.sentinel.annotation.SentinelResource;
import com.alibaba.csp.sentinel.annotation.aspectj.MethodWrapper;
import com.alibaba.csp.sentinel.annotation.aspectj.ResourceMetadataRegistry;
import com.alibaba.csp.sentinel.annotation.aspectj.SentinelAnnotationGlobalFallback;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.util.MethodUtil;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;

public abstract class AbstractSentinelAspectSupport {
    protected final SentinelAnnotationGlobalFallback globalFallback;

    public AbstractSentinelAspectSupport(SentinelAnnotationGlobalFallback globalFallback) {
        this.globalFallback = globalFallback;
    }

    protected void traceException(Throwable ex) {
        Tracer.trace(ex);
    }

    protected void traceException(Throwable ex, SentinelResource annotation) {
        Class<? extends Throwable>[] exceptionsToIgnore = annotation.exceptionsToIgnore();
        if (exceptionsToIgnore.length > 0 && this.exceptionBelongsTo(ex, exceptionsToIgnore)) {
            return;
        }
        if (this.exceptionBelongsTo(ex, annotation.exceptionsToTrace())) {
            this.traceException(ex);
        }
    }

    protected boolean exceptionBelongsTo(Throwable ex, Class<? extends Throwable>[] exceptions) {
        if (exceptions == null) {
            return false;
        }
        for (Class<? extends Throwable> exceptionClass : exceptions) {
            if (!exceptionClass.isAssignableFrom(ex.getClass())) continue;
            return true;
        }
        return false;
    }

    protected String getResourceName(String resourceName, Method method) {
        if (StringUtil.isNotBlank(resourceName)) {
            return resourceName;
        }
        return MethodUtil.resolveMethodName(method);
    }

    protected Object handleFallback(ProceedingJoinPoint pjp, SentinelResource annotation, Throwable ex) throws Throwable {
        return this.handleFallback(pjp, annotation.fallback(), annotation.defaultFallback(), annotation.fallbackClass(), ex);
    }

    protected Object handleFallback(ProceedingJoinPoint pjp, String fallback, String defaultFallback, Class<?>[] fallbackClass, Throwable ex) throws Throwable {
        Object[] originArgs = pjp.getArgs();
        Method fallbackMethod = this.extractFallbackMethod(pjp, fallback, fallbackClass);
        if (fallbackMethod != null) {
            Object[] args;
            int paramCount = fallbackMethod.getParameterTypes().length;
            if (paramCount == originArgs.length) {
                args = originArgs;
            } else {
                args = Arrays.copyOf(originArgs, originArgs.length + 1);
                args[args.length - 1] = ex;
            }
            try {
                if (this.isStatic(fallbackMethod)) {
                    return fallbackMethod.invoke(null, args);
                }
                return fallbackMethod.invoke(pjp.getTarget(), args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
        return this.handleDefaultFallback(pjp, defaultFallback, fallbackClass, ex);
    }

    protected Object handleDefaultFallback(ProceedingJoinPoint pjp, String defaultFallback, Class<?>[] fallbackClass, Throwable ex) throws Throwable {
        Method fallbackMethod = this.extractDefaultFallbackMethod(pjp, defaultFallback, fallbackClass);
        if (fallbackMethod != null) {
            Object[] objectArray;
            if (fallbackMethod.getParameterTypes().length == 0) {
                objectArray = new Object[]{};
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = ex;
            }
            Object[] args = objectArray;
            try {
                if (this.isStatic(fallbackMethod)) {
                    return fallbackMethod.invoke(null, args);
                }
                return fallbackMethod.invoke(pjp.getTarget(), args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
        return this.handleGlobalFallback(pjp, ex);
    }

    protected Object handleGlobalFallback(ProceedingJoinPoint pjp, Throwable t) throws Throwable {
        if (this.globalFallback == null) {
            throw t;
        }
        return this.globalFallback.handle(this.resolveMethod(pjp), pjp.getArgs(), t);
    }

    protected Object handleBlockException(ProceedingJoinPoint pjp, SentinelResource annotation, BlockException ex) throws Throwable {
        Method blockHandlerMethod = this.extractBlockHandlerMethod(pjp, annotation.blockHandler(), annotation.blockHandlerClass());
        if (blockHandlerMethod != null) {
            Object[] originArgs = pjp.getArgs();
            Object[] args = Arrays.copyOf(originArgs, originArgs.length + 1);
            args[args.length - 1] = ex;
            try {
                if (this.isStatic(blockHandlerMethod)) {
                    return blockHandlerMethod.invoke(null, args);
                }
                return blockHandlerMethod.invoke(pjp.getTarget(), args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
        return this.handleFallback(pjp, annotation, ex);
    }

    private Method extractFallbackMethod(ProceedingJoinPoint pjp, String fallbackName, Class<?>[] locationClass) {
        if (StringUtil.isBlank(fallbackName)) {
            return null;
        }
        boolean mustStatic = locationClass != null && locationClass.length >= 1;
        Class<?> clazz = mustStatic ? locationClass[0] : pjp.getTarget().getClass();
        MethodWrapper m = ResourceMetadataRegistry.lookupFallback(clazz, fallbackName);
        if (m == null) {
            Method method = this.resolveFallbackInternal(pjp, fallbackName, clazz, mustStatic);
            ResourceMetadataRegistry.updateFallbackFor(clazz, fallbackName, method);
            return method;
        }
        if (!m.isPresent()) {
            return null;
        }
        return m.getMethod();
    }

    private Method extractDefaultFallbackMethod(ProceedingJoinPoint pjp, String defaultFallback, Class<?>[] locationClass) {
        boolean mustStatic;
        Class<?> clazz;
        MethodWrapper m;
        if (StringUtil.isBlank(defaultFallback)) {
            SentinelResource annotationClass = pjp.getTarget().getClass().getAnnotation(SentinelResource.class);
            if (annotationClass != null && StringUtil.isNotBlank(annotationClass.defaultFallback())) {
                defaultFallback = annotationClass.defaultFallback();
                if (locationClass == null || locationClass.length < 1) {
                    locationClass = annotationClass.fallbackClass();
                }
            } else {
                return null;
            }
        }
        if ((m = ResourceMetadataRegistry.lookupDefaultFallback(clazz = (mustStatic = locationClass != null && locationClass.length >= 1) ? locationClass[0] : pjp.getTarget().getClass(), defaultFallback)) == null) {
            Class<?> originReturnType = this.resolveMethod(pjp).getReturnType();
            Class[] defaultParamTypes = new Class[]{};
            Class[] paramTypeWithException = new Class[]{Throwable.class};
            Method method = this.findMethod(mustStatic, clazz, defaultFallback, originReturnType, defaultParamTypes, true);
            if (method == null) {
                method = this.findMethod(mustStatic, clazz, defaultFallback, originReturnType, paramTypeWithException, true);
            }
            ResourceMetadataRegistry.updateDefaultFallbackFor(clazz, defaultFallback, method);
            return method;
        }
        if (!m.isPresent()) {
            return null;
        }
        return m.getMethod();
    }

    private Method resolveFallbackInternal(ProceedingJoinPoint pjp, String name, Class<?> clazz, boolean mustStatic) {
        Method originMethod = this.resolveMethod(pjp);
        Class<?>[] defaultParamTypes = originMethod.getParameterTypes();
        Class<?>[] paramTypesWithException = Arrays.copyOf(defaultParamTypes, defaultParamTypes.length + 1);
        paramTypesWithException[paramTypesWithException.length - 1] = Throwable.class;
        Method method = this.findMethod(mustStatic, clazz, name, originMethod.getReturnType(), defaultParamTypes, true);
        if (method == null) {
            method = this.findMethod(mustStatic, clazz, name, originMethod.getReturnType(), paramTypesWithException, true);
        }
        return method;
    }

    private Method extractBlockHandlerMethod(ProceedingJoinPoint pjp, String name, Class<?>[] locationClass) {
        if (StringUtil.isBlank(name)) {
            return null;
        }
        boolean mustStatic = locationClass != null && locationClass.length >= 1;
        Class<?> clazz = mustStatic ? locationClass[0] : pjp.getTarget().getClass();
        MethodWrapper m = ResourceMetadataRegistry.lookupBlockHandler(clazz, name);
        if (m == null) {
            Method method = this.resolveBlockHandlerInternal(pjp, name, clazz, mustStatic);
            ResourceMetadataRegistry.updateBlockHandlerFor(clazz, name, method);
            return method;
        }
        if (!m.isPresent()) {
            return null;
        }
        return m.getMethod();
    }

    private Method resolveBlockHandlerInternal(ProceedingJoinPoint pjp, String name, Class<?> clazz, boolean mustStatic) {
        Method originMethod = this.resolveMethod(pjp);
        Class<?>[] originList = originMethod.getParameterTypes();
        Class<?>[] parameterTypes = Arrays.copyOf(originList, originList.length + 1);
        parameterTypes[parameterTypes.length - 1] = BlockException.class;
        return this.findMethod(mustStatic, clazz, name, originMethod.getReturnType(), parameterTypes, true);
    }

    private boolean checkStatic(boolean mustStatic, Method method) {
        return !mustStatic || this.isStatic(method);
    }

    private Method findMethod(boolean mustStatic, Class<?> clazz, String name, Class<?> returnType, Class<?>[] parameterTypes, boolean allowVoidReturnType) {
        Method[] methods;
        for (Method method : methods = clazz.getDeclaredMethods()) {
            boolean voidType;
            if (!name.equals(method.getName()) || !this.checkStatic(mustStatic, method) || !Arrays.equals(parameterTypes, method.getParameterTypes())) continue;
            boolean bl = voidType = allowVoidReturnType && method.getReturnType().equals(Void.TYPE);
            if (!voidType && !returnType.isAssignableFrom(method.getReturnType())) continue;
            RecordLog.info("Resolved method [{0}] in class [{1}], returnType={2}", name, clazz.getCanonicalName(), method.getReturnType().getCanonicalName());
            return method;
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null && !Object.class.equals(superClass)) {
            return this.findMethod(mustStatic, superClass, name, returnType, parameterTypes, allowVoidReturnType);
        }
        String methodType = mustStatic ? " static" : "";
        RecordLog.warn("Cannot find{0} method [{1}] in class [{2}] with parameters {3}", methodType, name, clazz.getCanonicalName(), Arrays.toString(parameterTypes));
        return null;
    }

    private boolean isStatic(Method method) {
        return Modifier.isStatic(method.getModifiers());
    }

    protected Method resolveMethod(ProceedingJoinPoint joinPoint) {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Class<?> targetClass = joinPoint.getTarget().getClass();
        Method method = this.getDeclaredMethodFor(targetClass, signature.getName(), signature.getMethod().getParameterTypes());
        if (method == null) {
            throw new IllegalStateException("Cannot resolve target method: " + signature.getMethod().getName());
        }
        return method;
    }

    private Method getDeclaredMethodFor(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            return clazz.getDeclaredMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            Class<?> superClass = clazz.getSuperclass();
            if (superClass != null) {
                return this.getDeclaredMethodFor(superClass, name, parameterTypes);
            }
            return null;
        }
    }
}

