/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.client.auth.ssl;

import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public class NettySslContextFactory {
    private static final String PROTOCOL = "TLS";
    private static SSLContext clientContext;

    public static SSLContext getClientContext(String caPath) {
        if (clientContext != null) {
            return clientContext;
        }
        if (StringUtil.isBlank(caPath)) {
            throw new IllegalArgumentException("caPath should not be empty");
        }
        InputStream ins = null;
        try {
            KeyStore tks = KeyStore.getInstance("JKS");
            ins = new FileInputStream(caPath);
            tks.load(ins, "sNetty".toCharArray());
            TrustManagerFactory tf = TrustManagerFactory.getInstance("SunX509");
            tf.init(tks);
            clientContext = SSLContext.getInstance(PROTOCOL);
            clientContext.init(null, tf.getTrustManagers(), null);
        }
        catch (Exception e) {
            RecordLog.warn("Failed to initialize the client-side SSLContext", e);
            throw new IllegalStateException("Failed to initialize the client-side SSLContext", e);
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return clientContext;
    }
}

